/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.proposals.AbstractPyCompletionProposalExtension2;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;

public final class PyLinkedModeCompletionProposal
extends AbstractPyCompletionProposalExtension2
implements ICompletionProposalExtension {
    public static boolean addApplyTipOnAdditionalInfo = true;
    public int firstParameterLen = 0;
    private int nPositionsAdded = 0;
    private boolean goToLinkedMode = true;
    private IToken element;
    private int newForcedOffset = -1;
    private String computedInfo = null;
    private static final String MSG = "Enter: apply completion.\n  + Ctrl: remove arguments and replace current word (no Pop-up focus).\n  + Shift: remove arguments (requires Pop-up focus).\n";
    private static final String MSG2 = "Enter: apply completion.\n  + Ctrl: replace current word (no Pop-up focus).\n";
    public static IGoToLinkedModeHandler goToLinkedModeHandler;

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public int getOnApplyAction() {
        return this.onApplyAction;
    }

    public PyLinkedModeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IToken element, String displayString, IContextInformation contextInformation, int priority, int onApplyAction, String args, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, null, displayString, contextInformation, "", priority, onApplyAction, args, compareContext);
        this.element = element;
    }

    public IToken getElement() {
        return this.element;
    }

    public PyLinkedModeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args, compareContext);
    }

    public PyLinkedModeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args, boolean goToLinkedMode, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args, compareContext);
        this.goToLinkedMode = goToLinkedMode;
    }

    @Override
    public Image getImage() {
        if (this.element != null) {
            return ImageCache.asImage((IImageHandle)this.element.getImage());
        }
        return super.getImage();
    }

    @Override
    public String getAdditionalProposalInfo() {
        if (this.computedInfo != null) {
            return this.computedInfo;
        }
        if (this.element != null) {
            if (this.element instanceof SourceToken) {
                SourceToken sourceToken = (SourceToken)this.element;
                SimpleNode ast = sourceToken.getAst();
                if (ast != null && (ast instanceof FunctionDef || ast instanceof ClassDef)) {
                    this.computedInfo = this.addTipForApplyWithModifiers(NodeUtils.printAst(null, (SimpleNode)ast));
                }
                if (this.computedInfo != null) {
                    return this.computedInfo;
                }
            }
            this.computedInfo = this.addTipForApplyWithModifiers(this.element.getDocStr());
            return this.computedInfo;
        }
        return this.addTipForApplyWithModifiers(super.getAdditionalProposalInfo());
    }

    private String addTipForApplyWithModifiers(String string) {
        if (!addApplyTipOnAdditionalInfo) {
            return string;
        }
        String ret = string;
        if (this.onApplyAction == 1) {
            String msg = this.fReplacementString.indexOf(40) != -1 ? MSG : MSG2;
            ret = string == null || string.length() == 0 ? msg : String.valueOf(string) + "\n\n" + msg;
        }
        return ret;
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.newForcedOffset >= 0) {
            return new Point(this.newForcedOffset, 0);
        }
        if (this.onApplyAction == 2) {
            return null;
        }
        if (this.onApplyAction == 3) {
            if (this.fArgs.length() > 0) {
                return new Point(this.fReplacementOffset + this.fCursorPosition - 1, this.firstParameterLen);
            }
            return null;
        }
        if (this.onApplyAction == 1) {
            return new Point(this.fReplacementOffset + this.fCursorPosition + this.nPositionsAdded, this.firstParameterLen);
        }
        throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        ApplyDefaultBehavior noParamsAndOverwriteCurrentWord = ApplyDefaultBehavior.NO_CHANGE;
        if ((stateMask & SWT.MOD1) != 0) {
            noParamsAndOverwriteCurrentWord = ApplyDefaultBehavior.REMOVE_PARAMS_AND_REPLACE_TEXT;
        } else if ((stateMask & SWT.MOD2) != 0) {
            noParamsAndOverwriteCurrentWord = ApplyDefaultBehavior.REMOVE_PARAMS;
        }
        IDocument doc = viewer.getDocument();
        if (!this.triggerCharAppliesCurrentCompletion(trigger, doc, offset)) {
            this.newForcedOffset = offset + 1;
            return;
        }
        if (this.onApplyAction == 2) {
            return;
        }
        if (this.onApplyAction == 3) {
            try {
                String args = this.fArgs.length() > 0 ? this.fArgs.substring(1, this.fArgs.length() - 1) : "";
                super.apply(doc);
                if (!this.goToLinkedMode) {
                    return;
                }
                int iPar = -1;
                int exitPos = offset + args.length() + 1;
                this.goToLinkedModeFromArgs(viewer, offset, doc, exitPos, iPar, args);
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            return;
        }
        if (this.onApplyAction == 1) {
            try {
                int dif = offset - this.fReplacementOffset;
                String strToAdd = this.fReplacementString.substring(dif);
                boolean doReturn = this.applyOnDoc(offset, noParamsAndOverwriteCurrentWord, doc, dif, trigger);
                if (doReturn || !this.goToLinkedMode) {
                    return;
                }
                int iPar = strToAdd.indexOf(40);
                if (iPar != -1 && strToAdd.charAt(strToAdd.length() - 1) == ')') {
                    String newStr = strToAdd.substring(iPar + 1, strToAdd.length() - 1);
                    this.goToLinkedModeFromArgs(viewer, offset, doc, offset + strToAdd.length() + this.nPositionsAdded, iPar, newStr);
                }
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            return;
        }
        throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
    }

    public void applyOnDoc(int offset, boolean eat, IDocument doc, int dif, char trigger) throws BadLocationException {
        this.applyOnDoc(offset, eat ? ApplyDefaultBehavior.REMOVE_PARAMS_AND_REPLACE_TEXT : ApplyDefaultBehavior.NO_CHANGE, doc, dif, trigger);
    }

    public boolean applyOnDoc(int offset, ApplyDefaultBehavior eat, IDocument doc, int dif, char trigger) throws BadLocationException {
        boolean doReturn = false;
        String rep = this.fReplacementString;
        int iPar = rep.indexOf(40);
        if (eat == ApplyDefaultBehavior.REMOVE_PARAMS_AND_REPLACE_TEXT) {
            if (iPar != -1) {
                rep = rep.substring(0, iPar);
                doc.replace(offset - dif, dif + this.fLen, rep);
                if (!this.fLastIsPar) {
                    this.nPositionsAdded = -1;
                }
                doReturn = true;
            } else {
                int sumReplace = 0;
                if (rep.endsWith("=")) {
                    try {
                        char c = doc.getChar(offset + this.fLen);
                        if (c == '=') {
                            ++sumReplace;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                doc.replace(offset - dif, dif + this.fLen + sumReplace, rep);
            }
        } else {
            if (trigger == '.' || trigger == '(') {
                if (iPar != -1) {
                    rep = rep.substring(0, iPar);
                } else {
                    this.nPositionsAdded = 1;
                }
                rep = String.valueOf(rep) + trigger;
                if (trigger == '(') {
                    rep = String.valueOf(rep) + ')';
                }
                doReturn = true;
            } else if (eat == ApplyDefaultBehavior.REMOVE_PARAMS && iPar != -1) {
                rep = rep.substring(0, iPar);
                this.nPositionsAdded = -1;
                doReturn = true;
            }
            doc.replace(offset - dif, dif, rep);
        }
        return doReturn;
    }

    private void goToLinkedModeFromArgs(ITextViewer viewer, int offset, IDocument doc, int exitPos, int iPar, String newStr) throws BadLocationException {
        if (!this.goToLinkedMode) {
            return;
        }
        ArrayList<Integer> offsetsAndLens = new ArrayList<Integer>();
        PySelection.computeArgsOffsetsAndLens((String)newStr, offsetsAndLens);
        this.goToLinkedMode(viewer, offset, doc, exitPos, iPar, offsetsAndLens);
    }

    private void goToLinkedMode(ITextViewer viewer, int offset, IDocument doc, int exitPos, int iPar, List<Integer> offsetsAndLens) throws BadLocationException {
        if (!this.goToLinkedMode) {
            return;
        }
        if (offsetsAndLens.size() > 0) {
            Assert.isNotNull((Object)goToLinkedModeHandler, (String)"PyLinkedModeCompletionProposal.goToLinkedModeHandler must be set prior to usage.");
            goToLinkedModeHandler.goToLinkedMode(this, viewer, offset, doc, exitPos, iPar, offsetsAndLens);
        }
    }

    @Override
    public char[] getTriggerCharacters() {
        if (this.onApplyAction != 1) {
            return null;
        }
        return super.getTriggerCharacters();
    }

    public String toString() {
        return "PyLinkedModeCompletionProposal(" + this.getDisplayString() + ")";
    }

    public void setLen(int i) {
        this.fLen = i;
    }

    public static enum ApplyDefaultBehavior {
        NO_CHANGE,
        REMOVE_PARAMS,
        REMOVE_PARAMS_AND_REPLACE_TEXT;

    }

    public static interface IGoToLinkedModeHandler {
        public void goToLinkedMode(PyLinkedModeCompletionProposal var1, ITextViewer var2, int var3, IDocument var4, int var5, int var6, List<Integer> var7) throws BadLocationException;
    }
}

