/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.javaintegration;

import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.codecompletion.revisited.modules.EmptyModuleForZip;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaZipModule;

public class JythonModulesManagerUtils {
    public static AbstractModule createModuleFromJar(EmptyModuleForZip emptyModuleForZip, IPythonNature nature) throws JDTNotAvailableException {
        try {
            return new JavaZipModule(emptyModuleForZip, nature);
        }
        catch (Throwable e) {
            Log.log((String)("Unable to create java module for (note: JDT is required for Jython development): " + emptyModuleForZip));
            JythonModulesManagerUtils.tryRethrowAsJDTNotAvailableException(e);
            throw new RuntimeException("Should never get here", e);
        }
    }

    public static void tryRethrowAsJDTNotAvailableException(Throwable e) throws JDTNotAvailableException {
        if (JythonModulesManagerUtils.isOptionalJDTClassNotFound(e)) {
            throw new JDTNotAvailableException();
        }
        if (e instanceof JDTNotAvailableException) {
            JDTNotAvailableException jdtNotAvailableException = (JDTNotAvailableException)e;
            throw jdtNotAvailableException;
        }
        if (e instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)e;
            throw runtimeException;
        }
        Log.log((Throwable)e);
        throw new RuntimeException(e);
    }

    public static boolean isOptionalJDTClassNotFound(Throwable e) {
        return e instanceof LinkageError || e instanceof ClassNotFoundException || e instanceof NoClassDefFoundError;
    }
}

