/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.FoldingEntry;
import org.python.pydev.editor.codefolding.PyProjectionAnnotation;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.CodeFoldingVisitor;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.IModelListener;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.DocIterator;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor.IPyEditListener3;

public class CodeFoldingSetter
implements IModelListener,
IPropertyListener,
IPyEditListener,
IPyEditListener3 {
    private PyEdit editor;
    private volatile boolean initialFolding;
    private volatile boolean firstInputChangedCalled = false;
    private static final Pattern regionStartPattern = Pattern.compile("(\\s)*#(\\s)*\\bregion\\b");
    private static final Pattern regionEndPattern = Pattern.compile("(\\s)*#(\\s)*\\bendregion\\b");
    private static IEclipsePreferences testingPrefs;

    public CodeFoldingSetter(PyEdit editor) {
        this.editor = editor;
        this.initialFolding = true;
        editor.addModelListener(this);
        editor.addPropertyListener(this);
        editor.addPyeditListener(this);
    }

    public void onInputChanged(BaseEditor edit, IEditorInput oldInput, IEditorInput input, IProgressMonitor monitor) {
        this.initialFolding = true;
        this.firstInputChangedCalled = true;
    }

    public void onSave(BaseEditor edit, IProgressMonitor monitor) {
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor edit, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor edit, IProgressMonitor monitor) {
        edit.removeModelListener((IModelListener)this);
        edit.removePropertyListener((IPropertyListener)this);
        edit.removePyeditListener((IPyEditListener)this);
    }

    public void onSetDocument(IDocument document, BaseEditor edit, IProgressMonitor monitor) {
    }

    public synchronized void modelChanged(ISimpleNode ast) {
        SimpleNode root2 = (SimpleNode)ast;
        if (!this.firstInputChangedCalled) {
            this.asyncUpdateWaitingFormModelAndInputChanged(root2);
            return;
        }
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.editor.getAdapter(ProjectionAnnotationModel.class);
        if (model == null) {
            this.asyncUpdateWaitingFormModelAndInputChanged(root2);
        } else {
            this.addMarksToModel(root2, model);
        }
    }

    private void asyncUpdateWaitingFormModelAndInputChanged(final SimpleNode ast) {
        Thread t = new Thread(){

            @Override
            public void run() {
                ProjectionAnnotationModel modelT = null;
                int i = 0;
                while (i < 10 && modelT == null || !CodeFoldingSetter.this.firstInputChangedCalled) {
                    try {
                        1.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Log.log((Throwable)e);
                    }
                    modelT = (ProjectionAnnotationModel)CodeFoldingSetter.this.editor.getAdapter(ProjectionAnnotationModel.class);
                    if (modelT != null) {
                        CodeFoldingSetter.this.addMarksToModel(ast, modelT);
                        break;
                    }
                    ++i;
                }
            }
        };
        t.setPriority(1);
        t.setName("CodeFolding - get annotation model");
        t.start();
    }

    private synchronized void addMarksToModel(SimpleNode root2, ProjectionAnnotationModel model) {
        try {
            if (model != null) {
                ArrayList<Annotation> existing = new ArrayList<Annotation>();
                Iterator iter = model.getAnnotationIterator();
                while (iter != null && iter.hasNext()) {
                    Annotation element = (Annotation)iter.next();
                    existing.add(element);
                }
                IDocument doc = this.editor.getDocument();
                if (doc != null) {
                    boolean foldInitial = this.initialFolding;
                    this.initialFolding = false;
                    List<FoldingEntry> marks = CodeFoldingSetter.getMarks(doc, root2, foldInitial, (IAdaptable)this.editor);
                    Map<Object, Object> annotationsToAdd = marks.size() > 4000 ? new HashMap() : this.getAnnotationsToAdd(marks, model, existing);
                    model.replaceAnnotations(existing.toArray(new Annotation[existing.size()]), annotationsToAdd);
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private Map<ProjectionAnnotation, Position> getAnnotationsToAdd(List<FoldingEntry> nodes, ProjectionAnnotationModel model, List<Annotation> existing) {
        HashMap<ProjectionAnnotation, Position> annotationsToAdd = new HashMap<ProjectionAnnotation, Position>();
        try {
            for (FoldingEntry element : nodes) {
                Tuple<ProjectionAnnotation, Position> tup;
                if (element.startLine >= element.endLine - 1 || (tup = this.getAnnotationToAdd(element, element.startLine, element.endLine, model, existing)) == null) continue;
                annotationsToAdd.put((ProjectionAnnotation)tup.o1, (Position)tup.o2);
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return annotationsToAdd;
    }

    private Tuple<ProjectionAnnotation, Position> getAnnotationToAdd(FoldingEntry node, int start, int end, ProjectionAnnotationModel model, List<Annotation> existing) throws BadLocationException {
        try {
            int offset;
            IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            int endOffset = offset = document.getLineOffset(start);
            try {
                endOffset = document.getLineOffset(end);
            }
            catch (Exception e) {
                IRegion lineInformation = document.getLineInformation(end);
                endOffset = lineInformation.getOffset() + lineInformation.getLength();
            }
            Position position = new Position(offset, endOffset - offset);
            return this.getAnnotationToAdd(position, node, model, existing);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private Tuple<ProjectionAnnotation, Position> getAnnotationToAdd(Position position, FoldingEntry node, ProjectionAnnotationModel model, List<Annotation> existing) {
        for (Annotation element : existing) {
            Position existingPosition = model.getPosition(element);
            if (!existingPosition.equals((Object)position)) continue;
            existing.remove(element);
            return null;
        }
        return new Tuple((Object)new PyProjectionAnnotation(node.getAstEntry(), node.isCollapsed), (Object)position);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == -999) {
            this.modelChanged((ISimpleNode)this.editor.getAST());
        }
    }

    private static boolean getBooleanPreference(String key, IAdaptable projectAdaptable) {
        IEclipsePreferences prefs = CodeFoldingSetter.getPreferences();
        IEclipsePreferences defaultPrefs = PydevPrefs.getDefaultEclipsePreferences();
        return PyScopedPreferences.get().getBoolean(prefs, defaultPrefs, key, projectAdaptable);
    }

    public static List<FoldingEntry> getMarks(IDocument doc, SimpleNode ast, boolean foldInitial, IAdaptable projectAdaptable) {
        ArrayList<FoldingEntry> ret = new ArrayList<FoldingEntry>();
        CodeFoldingVisitor visitor = CodeFoldingVisitor.create((SimpleNode)ast);
        if (CodeFoldingSetter.getBooleanPreference("FOLD_IMPORTS", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_IMPORTS", projectAdaptable) : false, Import.class, ImportFrom.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_CLASSDEF", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_CLASSDEF", projectAdaptable) : false, ClassDef.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_FUNCTIONDEF", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_FUNCTIONDEF", projectAdaptable) : false, FunctionDef.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_STRINGS", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_STRINGS", projectAdaptable) : false, Str.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_WHILE", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_WHILE", projectAdaptable) : false, While.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_IF", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_IF", projectAdaptable) : false, If.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_FOR", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_FOR", projectAdaptable) : false, For.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_WITH", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_WITH", projectAdaptable) : false, With.class);
        }
        if (CodeFoldingSetter.getBooleanPreference("FOLD_TRY", projectAdaptable)) {
            CodeFoldingSetter.createFoldingEntries(ret, visitor, foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_TRY", projectAdaptable) : false, TryExcept.class, TryFinally.class);
        }
        boolean foldComments = CodeFoldingSetter.getBooleanPreference("FOLD_COMMENTS", projectAdaptable);
        boolean foldRegions = CodeFoldingSetter.getBooleanPreference("FOLD_REGION", projectAdaptable);
        if (foldComments || foldRegions) {
            boolean collapseComments = foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_COLLAPSE_COMMENTS", projectAdaptable) : false;
            boolean collapseRegions = foldInitial ? CodeFoldingSetter.getBooleanPreference("INITIALLY_FOLD_REGION", projectAdaptable) : false;
            DocIterator it = new DocIterator(true, (TextSelectionUtils)new PySelection(doc, 0));
            Stack<Integer> stack = new Stack<Integer>();
            while (it.hasNext()) {
                int l;
                String string = it.next();
                Matcher regionStartMatcher = regionStartPattern.matcher(string);
                Matcher regionEndMatcher = regionEndPattern.matcher(string);
                boolean isLookingAtRegionStart = regionStartMatcher.lookingAt();
                boolean isLookingAtRegionEnd = regionEndMatcher.lookingAt();
                if (foldComments && string.trim().startsWith("#") && !isLookingAtRegionStart && !isLookingAtRegionEnd) {
                    l = it.getCurrentLine() - 1;
                    CodeFoldingSetter.addFoldingEntry(ret, new FoldingEntry(3, l, l + 1, new ASTEntry(null, (SimpleNode)new commentType(string)), collapseComments));
                }
                if (!foldRegions) continue;
                if (isLookingAtRegionStart) {
                    l = it.getCurrentLine() - 1;
                    stack.push(l);
                }
                if (!isLookingAtRegionEnd) continue;
                l = it.getCurrentLine() - 1;
                if (stack.size() <= 0) continue;
                int l_start = (Integer)stack.pop();
                CodeFoldingSetter.addFoldingEntry(ret, new FoldingEntry(9, l_start, l + 1, new ASTEntry(null, (SimpleNode)new commentType(string)), collapseRegions));
            }
        }
        Collections.sort(ret, new Comparator<FoldingEntry>(){

            @Override
            public int compare(FoldingEntry o1, FoldingEntry o2) {
                if (o1.startLine < o2.startLine) {
                    return -1;
                }
                if (o1.startLine > o2.startLine) {
                    return 1;
                }
                return 0;
            }
        });
        return ret;
    }

    private static void createFoldingEntries(List<FoldingEntry> ret, CodeFoldingVisitor visitor, boolean collapse, Class ... elementClasses) {
        List nodes = visitor.getAsList(elementClasses);
        for (ASTEntry entry : nodes) {
            CodeFoldingSetter.createFoldingEntries((ASTEntryWithChildren)entry, ret, collapse);
        }
    }

    private static void createFoldingEntries(ASTEntryWithChildren entry, List<FoldingEntry> ret, boolean collapse) {
        FoldingEntry foldingEntry = null;
        if (entry.node instanceof Import || entry.node instanceof ImportFrom) {
            foldingEntry = new FoldingEntry(1, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof ClassDef) {
            ClassDef def = (ClassDef)entry.node;
            foldingEntry = new FoldingEntry(2, def.name.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof FunctionDef) {
            FunctionDef def = (FunctionDef)entry.node;
            foldingEntry = new FoldingEntry(2, def.name.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof TryExcept) {
            foldingEntry = new FoldingEntry(7, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            TryExcept tryStmt = (TryExcept)entry.node;
            if (tryStmt.handlers != null) {
                excepthandlerType[] excepthandlerTypeArray = tryStmt.handlers;
                int n = tryStmt.handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    excepthandlerType except = excepthandlerTypeArray[n2];
                    foldingEntry = CodeFoldingSetter.checkExcept(entry, ret, foldingEntry, entry.endLine, except);
                    ++n2;
                }
            }
            if (tryStmt.orelse != null) {
                foldingEntry = CodeFoldingSetter.checkOrElse(entry, ret, foldingEntry, entry.endLine, tryStmt.orelse);
            }
        } else if (entry.node instanceof TryFinally) {
            TryFinally tryStmt = (TryFinally)entry.node;
            if (!(tryStmt.body == null || tryStmt.body.length <= 0 || tryStmt.body[0] instanceof TryExcept && tryStmt.body[0].beginLine == tryStmt.beginLine)) {
                foldingEntry = new FoldingEntry(8, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            }
            if (tryStmt.finalbody != null) {
                if (foldingEntry != null) {
                    foldingEntry = CodeFoldingSetter.checkFinally(entry, ret, foldingEntry, entry.endLine, tryStmt.finalbody, true);
                } else {
                    foldingEntry = new FoldingEntry(8, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
                    foldingEntry = CodeFoldingSetter.checkFinally(entry, ret, foldingEntry, entry.endLine, tryStmt.finalbody, false);
                }
            }
        } else if (entry.node instanceof With) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof While) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            foldingEntry = CodeFoldingSetter.checkOrElse(entry, ret, foldingEntry, entry.endLine, ((While)entry.node).orelse);
        } else if (entry.node instanceof For) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
            foldingEntry = CodeFoldingSetter.checkOrElse(entry, ret, foldingEntry, entry.endLine, ((For)entry.node).orelse);
        } else if (entry.node instanceof If) {
            foldingEntry = new FoldingEntry(5, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        } else if (entry.node instanceof Str && entry.node.beginLine != entry.endLine) {
            foldingEntry = new FoldingEntry(4, entry.node.beginLine - 1, entry.endLine, (ASTEntry)entry);
        }
        if (foldingEntry != null) {
            foldingEntry.isCollapsed = collapse;
            CodeFoldingSetter.addFoldingEntry(ret, foldingEntry);
        }
    }

    private static FoldingEntry checkOrElse(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, suiteType orelse) {
        return CodeFoldingSetter.checkOrElseSuite(entry, ret, foldingEntry, blockEndLine, (SimpleNode)orelse, 6, "else", true);
    }

    private static FoldingEntry checkFinally(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, suiteType orelse, boolean addPrevious) {
        return CodeFoldingSetter.checkOrElseSuite(entry, ret, foldingEntry, blockEndLine, (SimpleNode)orelse, 8, "finally", addPrevious);
    }

    private static FoldingEntry checkExcept(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, excepthandlerType orelse) {
        return CodeFoldingSetter.checkOrElseSuite(entry, ret, foldingEntry, blockEndLine, (SimpleNode)orelse, 7, "except", true);
    }

    private static FoldingEntry checkOrElseSuite(ASTEntryWithChildren entry, List<FoldingEntry> ret, FoldingEntry foldingEntry, int blockEndLine, SimpleNode orelse, int type, String specialToken, boolean addPrevious) {
        if (orelse != null && orelse.specialsBefore != null) {
            for (Object o : orelse.specialsBefore) {
                ISpecialStr specialStr;
                if (!(o instanceof ISpecialStr) || !(specialStr = (ISpecialStr)o).toString().equals(specialToken)) continue;
                foldingEntry.endLine = specialStr.getBeginLine() - 1;
                if (addPrevious) {
                    CodeFoldingSetter.addFoldingEntry(ret, foldingEntry);
                }
                foldingEntry = new FoldingEntry(type, specialStr.getBeginLine() - 1, blockEndLine, (ASTEntry)entry);
            }
        }
        return foldingEntry;
    }

    private static IEclipsePreferences getPreferences() {
        if (testingPrefs == null) {
            return PydevPrefs.getEclipsePreferences();
        }
        return testingPrefs;
    }

    public static void setPreferences(IEclipsePreferences prefs) {
        testingPrefs = prefs;
    }

    private static void addFoldingEntry(List<FoldingEntry> ret, FoldingEntry foldingEntry) {
        if (ret.size() > 0 && (foldingEntry.type == 3 || foldingEntry.type == 1)) {
            FoldingEntry prev = ret.get(ret.size() - 1);
            if (prev.type == foldingEntry.type && prev.startLine < foldingEntry.startLine && prev.endLine == foldingEntry.startLine) {
                prev.endLine = foldingEntry.endLine;
            } else {
                ret.add(foldingEntry);
            }
        } else {
            ret.add(foldingEntry);
        }
    }

    public void errorChanged(ErrorDescription errorDesc) {
    }
}

