/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.ColorCache;
import org.python.pydev.shared_ui.editor.IVerticalIndentGuidePreferencesProvider;

public abstract class PyAbstractIndentGuidePreferencesProvider
implements IVerticalIndentGuidePreferencesProvider,
IPropertyChangeListener {
    private boolean showIndentGuide;
    private boolean useEditorForegroundColor;
    private int transparency;
    private IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();

    public PyAbstractIndentGuidePreferencesProvider() {
        this.showIndentGuide = this.chainedPrefStore.getBoolean("USE_VERTICAL_INDENT_GUIDE");
        this.useEditorForegroundColor = this.chainedPrefStore.getBoolean("USE_VERTICAL_INDENT_COLOR_EDITOR_FOREGROUND");
        this.setTransparency(this.chainedPrefStore.getInt("VERTICAL_INDENT_TRANSPARENCY"));
        this.chainedPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void setTransparency(int newVal) {
        if (newVal < 0) {
            newVal = 0;
        }
        if (newVal > 255) {
            newVal = 255;
        }
        this.transparency = newVal;
    }

    public boolean getShowIndentGuide() {
        return this.showIndentGuide;
    }

    public void dispose() {
        if (this.chainedPrefStore != null) {
            this.chainedPrefStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.chainedPrefStore = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("USE_VERTICAL_INDENT_GUIDE".equals(event.getProperty())) {
            this.showIndentGuide = this.chainedPrefStore.getBoolean("USE_VERTICAL_INDENT_GUIDE");
        } else if ("USE_VERTICAL_INDENT_COLOR_EDITOR_FOREGROUND".equals(event.getProperty())) {
            this.useEditorForegroundColor = this.chainedPrefStore.getBoolean("USE_VERTICAL_INDENT_COLOR_EDITOR_FOREGROUND");
        } else if ("VERTICAL_INDENT_TRANSPARENCY".equals(event.getProperty())) {
            this.setTransparency(this.chainedPrefStore.getInt("VERTICAL_INDENT_TRANSPARENCY"));
        }
    }

    public Color getColor(StyledText styledText) {
        if (this.useEditorForegroundColor) {
            return styledText.getForeground();
        }
        ColorCache colorCache = PydevPlugin.getColorCache();
        return colorCache.getColor("VERTICAL_INDENT_COLOR");
    }

    public int getTransparency() {
        return this.transparency;
    }
}

