/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.commentblocks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.FontUtils;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class CommentBlocksPreferences
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor multiBlock;
    private StringFieldEditor singleBlock;
    private BooleanFieldEditor alignSingle;
    private Label labelSep0;
    private Label labelMulti;
    private Label labelSingle;
    private Label labelSep1;
    public static final String MULTI_BLOCK_COMMENT_CHAR = "MULTI_BLOCK_COMMENT_CHAR";
    public static final String DEFAULT_MULTI_BLOCK_COMMENT_CHAR = "=";
    public static final String MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME = "MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME";
    public static final boolean DEFAULT_MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME = true;
    public static final String MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME = "MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME";
    public static final boolean DEFAULT_MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME = true;
    public static final String SINGLE_BLOCK_COMMENT_CHAR = "SINGLE_BLOCK_COMMENT_CHAR";
    public static final String DEFAULT_SINGLE_BLOCK_COMMENT_CHAR = "-";
    public static final String SINGLE_BLOCK_COMMENT_ALIGN_RIGHT = "SINGLE_BLOCK_COMMENT_ALIGN_RIGHT";
    public static final boolean DEFAULT_SINGLE_BLOCK_COMMENT_ALIGN_RIGHT = true;
    public static final String ADD_COMMENTS_OPTION = "ADD_COMMENTS_OPTION";
    private static final String[][] ENTRIES_AND_VALUES_FOR_ADD_COMMENTS_OPTION = new String[][]{{"Indent", "ADD_COMMENTS_INDENT"}, {"Line start", "ADD_COMMENTS_LINE_START"}, {"Indent (computed for each line)", "ADD_COMMENTS_INDENT_LINE_ORIENTED"}};

    public CommentBlocksPreferences() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Comment Preferences");
    }

    public static final List<String> getValuesForAddCommentsOption() {
        ArrayList<String> ret = new ArrayList<String>();
        String[][] stringArray = ENTRIES_AND_VALUES_FOR_ADD_COMMENTS_OPTION;
        int n = ENTRIES_AND_VALUES_FOR_ADD_COMMENTS_OPTION.length;
        int n2 = 0;
        while (n2 < n) {
            String[] option = stringArray[n2];
            ret.add(option[1]);
            ++n2;
        }
        return ret;
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new ComboFieldEditor(ADD_COMMENTS_OPTION, "Comment location", ENTRIES_AND_VALUES_FOR_ADD_COMMENTS_OPTION, p));
        this.labelSep0 = new Label(p, 0);
        this.labelSep0.setText("       (otherwise, add '#' to the start of the line)");
        this.labelSep1 = new Label(p, 0);
        this.multiBlock = new StringFieldEditor(MULTI_BLOCK_COMMENT_CHAR, "Multi-block char (ctrl+4):", 2, p);
        this.multiBlock.getTextControl(p).setTextLimit(1);
        this.multiBlock.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.multiBlock);
        this.addField((FieldEditor)new BooleanFieldEditor(MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME, "In a class name, create block only with class name above of class?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME, "In a function name, create block only with function name above of function?", p));
        this.labelMulti = new Label(p, 0);
        this.singleBlock = new StringFieldEditor(SINGLE_BLOCK_COMMENT_CHAR, "Single-block char (ctrl+shift+4):", 2, p);
        this.singleBlock.setEmptyStringAllowed(false);
        this.singleBlock.getTextControl(p).setTextLimit(1);
        this.addField((FieldEditor)this.singleBlock);
        this.alignSingle = new BooleanFieldEditor(SINGLE_BLOCK_COMMENT_ALIGN_RIGHT, "Align text in single-block to the right?", p);
        this.addField((FieldEditor)this.alignSingle);
        this.labelSingle = new Label(p, 0);
        this.setLabelFont(p, this.labelSingle, true);
        this.setLabelFont(p, this.labelMulti, true);
        this.updateMulti(PyScopedPreferences.getString((String)MULTI_BLOCK_COMMENT_CHAR, null));
        this.updateSingle(PyScopedPreferences.getString((String)SINGLE_BLOCK_COMMENT_CHAR, null), PyScopedPreferences.getBoolean((String)SINGLE_BLOCK_COMMENT_ALIGN_RIGHT, null));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private void setLabelFont(Composite composite, Label label, boolean bold) {
        try {
            FontData labelFontData = FontUtils.getFontData((int)2, (boolean)true);
            if (bold) {
                labelFontData.setStyle(1);
            }
            label.setFont(new Font((Device)composite.getDisplay(), labelFontData));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void updateSingle(String val, boolean alignToRight) {
        FastStringBuffer buf = new FastStringBuffer(200);
        if (val.length() == 0) {
            buf.append("Invalid");
            buf.appendN(' ', 23);
        } else {
            buf.appendN(val.charAt(0), 10);
            if (alignToRight) {
                buf.append(" my single block");
            } else {
                buf.insert(0, " my single block ");
            }
            buf.insert(0, '#');
        }
        this.labelSingle.setText("Result:\n" + buf.toString());
    }

    private void updateMulti(String val) {
        FastStringBuffer buf = new FastStringBuffer(200);
        if (val.length() == 0) {
            buf.append("Invalid");
            buf.appendN(' ', 23);
            buf.append('\n');
            buf.appendN(' ', 30);
            buf.append('\n');
            buf.appendN(' ', 30);
        } else {
            buf.append("#");
            buf.appendN(val.charAt(0), 26);
            buf.append("\n# my multi block");
            buf.append("\n#");
            buf.appendN(val.charAt(0), 26);
        }
        this.labelMulti.setText("Result:\n" + buf.toString() + "\n\n\n");
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.multiBlock.equals(event.getSource())) {
            this.updateMulti(this.multiBlock.getStringValue());
        } else if (this.singleBlock.equals(event.getSource()) || this.alignSingle.equals(event.getSource())) {
            this.updateSingle(this.singleBlock.getStringValue(), this.alignSingle.getBooleanValue());
        }
    }
}

