/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;

public class FixCompletionProposal
implements ICompletionProposal,
ICompletionProposalHandle {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private IImageHandle fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private int lineToRemove;

    public FixCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int lineToRemove) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.lineToRemove = lineToRemove;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            if (this.lineToRemove >= 0 && this.lineToRemove <= document.getNumberOfLines()) {
                IRegion lineInformation = document.getLineInformation(this.lineToRemove);
                document.replace(lineInformation.getOffset(), lineInformation.getLength(), "");
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        if (this.lineToRemove >= 0 && this.lineToRemove <= document.getNumberOfLines()) {
            try {
                IRegion lineInformation = document.getLineInformation(this.lineToRemove);
                int pos = lineInformation.getOffset();
                return new Point(pos, 0);
            }
            catch (BadLocationException e) {
                return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
            }
        }
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return ImageCache.asImage((IImageHandle)this.fImage);
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }
}

