/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.python.pydev.ast.formatter.PyFormatter;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.formatter.PyFormatterPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.correctionassist.IgnoreCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class IgnoreCompletionProposalInSameLine
extends IgnoreCompletionProposal {
    private String line;
    private PySelection ps;
    private FormatStd format;

    public IgnoreCompletionProposalInSameLine(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, IPyEdit edit, String line, PySelection ps, FormatStd format) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, edit);
        this.line = line;
        this.ps = ps;
        this.format = format;
    }

    @Override
    public void apply(IDocument document) {
        String messageToIgnore = this.fReplacementString;
        FastStringBuffer strToAdd = new FastStringBuffer(messageToIgnore, 5);
        int lineLen = this.line.length();
        int endLineIndex = this.ps.getEndLineOffset();
        boolean isComment = ParsingUtils.isCommentPartition((IDocument)document, (int)endLineIndex);
        int whitespacesAtEnd = 0;
        char c = '\u0000';
        int i = lineLen - 1;
        while (i >= 0) {
            c = this.line.charAt(i);
            if (c != ' ') break;
            ++whitespacesAtEnd;
            --i;
        }
        if (isComment) {
            if (whitespacesAtEnd == 0) {
                strToAdd.insert(0, ' ');
            }
        } else {
            FormatStd formatStd = this.format;
            if (formatStd == null) {
                if (this.edit != null) {
                    formatStd = ((PyEdit)this.edit).getFormatStd();
                } else {
                    Log.log((String)"Error: using default format (not considering project preferences).");
                    formatStd = PyFormatterPreferences.getFormatStd(null);
                }
            }
            strToAdd.insert(0, '#');
            PyFormatter.formatComment((FormatStd)formatStd, (FastStringBuffer)strToAdd, (boolean)true);
            if (c != '\r' && c != '\n' && c != '\u0000' && c != ' ') {
                int spacesBeforeComment = formatStd.spacesBeforeComment;
                if (spacesBeforeComment < 0) {
                    spacesBeforeComment = 1;
                }
                if ((spacesBeforeComment -= whitespacesAtEnd) > 0) {
                    strToAdd.insertN(0, ' ', spacesBeforeComment);
                }
            }
        }
        this.fReplacementString = strToAdd.toString();
        super.apply(document);
    }
}

