/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.python.pydev.ast.formatter.PyFormatter;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.formatter.PyFormatterPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.correctionassist.IgnoreCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class IgnoreFlake8CompletionProposalInSameLine
extends IgnoreCompletionProposal {
    private String line;
    private PySelection ps;
    private FormatStd format;
    private IMarker marker;

    public IgnoreFlake8CompletionProposalInSameLine(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, IPyEdit edit, String line, PySelection ps, FormatStd format, IMarker marker) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, edit);
        this.line = line;
        this.ps = ps;
        this.format = format;
        this.marker = marker;
    }

    @Override
    protected boolean getForceReparse() {
        return false;
    }

    @Override
    public void apply(IDocument document) {
        FastStringBuffer strToAdd;
        String messageId = this.fReplacementString;
        int lineLen = this.line.length();
        int endLineIndex = this.ps.getEndLineOffset();
        boolean isComment = ParsingUtils.isCommentPartition((IDocument)document, (int)endLineIndex);
        int whitespacesAtEnd = 0;
        char c = '\u0000';
        int i = lineLen - 1;
        while (i >= 0) {
            c = this.line.charAt(i);
            if (c != ' ') break;
            ++whitespacesAtEnd;
            --i;
        }
        if (isComment) {
            strToAdd = new FastStringBuffer("", 40);
            if (this.line.contains("noqa:")) {
                strToAdd.append(", ");
                strToAdd.append(messageId);
            } else {
                if (whitespacesAtEnd == 0) {
                    strToAdd.append(' ');
                }
                strToAdd.append("noqa:");
                strToAdd.append(messageId);
            }
        } else {
            FormatStd formatStd = this.format;
            if (formatStd == null) {
                if (this.edit != null) {
                    formatStd = ((PyEdit)this.edit).getFormatStd();
                } else {
                    Log.log((String)"Error: using default format (not considering project preferences).");
                    formatStd = PyFormatterPreferences.getFormatStd(null);
                }
            }
            strToAdd = new FastStringBuffer("", 40);
            strToAdd.append('#');
            PyFormatter.formatComment((FormatStd)formatStd, (FastStringBuffer)strToAdd, (boolean)true);
            if (c != '\r' && c != '\n' && c != '\u0000' && c != ' ') {
                int spacesBeforeComment = formatStd.spacesBeforeComment;
                if (spacesBeforeComment < 0) {
                    spacesBeforeComment = 1;
                }
                if ((spacesBeforeComment -= whitespacesAtEnd) > 0) {
                    strToAdd.insertN(0, ' ', spacesBeforeComment);
                }
            }
            strToAdd.append("noqa:");
            strToAdd.append(messageId);
        }
        this.fReplacementString = strToAdd.toString();
        super.apply(document);
        if (this.marker != null) {
            try {
                this.marker.delete();
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
    }
}

