/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.texteditor.spelling.NoCompletionsProposal;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.python.pydev.ast.codecompletion.ProposalsComparator;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.correctionassist.IAssistProps;
import org.python.pydev.editor.correctionassist.docstrings.AssistDocString;
import org.python.pydev.editor.correctionassist.heuristics.AssistAssign;
import org.python.pydev.editor.correctionassist.heuristics.AssistFString;
import org.python.pydev.editor.correctionassist.heuristics.AssistImport;
import org.python.pydev.editor.correctionassist.heuristics.AssistImportToLocal;
import org.python.pydev.editor.correctionassist.heuristics.AssistPercentToFormat;
import org.python.pydev.editor.correctionassist.heuristics.AssistSurroundWith;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PythonCorrectionProcessor
implements IQuickAssistProcessor {
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;
    private static Map<String, IAssistProps> additionalAssists = new HashMap<String, IAssistProps>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            return additionalAssists.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdditionalAssist(String id, IAssistProps assist) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.put(id, assist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.remove(id);
        }
    }

    public PythonCorrectionProcessor(IPySyntaxHighlightingAndCodeCompletionEditor edit) {
        this.edit = edit;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        int offset = invocationContext.getOffset();
        PySelection base = this.edit.createPySelection();
        if (!(this.edit instanceof PyEdit) || base == null) {
            return new ICompletionProposal[0];
        }
        PyEdit editor = (PyEdit)this.edit;
        ArrayList<ICompletionProposalHandle> results = new ArrayList<ICompletionProposalHandle>();
        String sel = PyAction.getLineWithoutComments(base);
        ArrayList<IAssistProps> assists = new ArrayList<IAssistProps>();
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            for (IAssistProps prop : additionalAssists.values()) {
                assists.add(prop);
            }
        }
        assists.add(new AssistSurroundWith());
        assists.add(new AssistImport());
        assists.add(new AssistDocString());
        assists.add(new AssistAssign());
        assists.add(new AssistPercentToFormat());
        assists.add(new AssistImportToLocal());
        assists.add(new AssistFString());
        assists.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_ctrl_1"));
        IImageCache imageCache = SharedUiPlugin.getImageCache();
        File editorFile = this.edit.getEditorFile();
        IPythonNature pythonNature = null;
        try {
            pythonNature = this.edit.getPythonNature();
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
        }
        for (IAssistProps assist : assists) {
            PySelection ps = new PySelection(base);
            try {
                if (!assist.isValid(ps, sel, editor, offset)) continue;
                try {
                    results.addAll(assist.getProps(ps, imageCache, editorFile, pythonNature, editor, offset));
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        Collections.sort(results, new ProposalsComparator("", (IPyCompletionProposal.ICompareContext)new ProposalsComparator.CompareContext(pythonNature)));
        try {
            ICompletionProposal[] spellProps = null;
            IAnnotationModel annotationModel = editor.getPySourceViewer().getAnnotationModel();
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                if (!(annotation instanceof SpellingAnnotation)) continue;
                SpellingAnnotation spellingAnnotation = (SpellingAnnotation)annotation;
                SpellingProblem spellingProblem = spellingAnnotation.getSpellingProblem();
                int problemOffset = spellingProblem.getOffset();
                int problemLen = spellingProblem.getLength();
                if (problemOffset > offset || problemOffset + problemLen < offset) continue;
                SpellingCorrectionProcessor spellingCorrectionProcessor = new SpellingCorrectionProcessor();
                spellProps = spellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
                break;
            }
            if (spellProps == null || spellProps.length == 1 && spellProps[0] instanceof NoCompletionsProposal) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            ICompletionProposal[] ret = results.toArray(new ICompletionProposal[results.size() + spellProps.length]);
            System.arraycopy(spellProps, 0, ret, results.size(), spellProps.length);
            return ret;
        }
        catch (Throwable e) {
            if (e instanceof ClassNotFoundException || e instanceof LinkageError || e instanceof NoSuchMethodException || e instanceof NoSuchMethodError || e instanceof NoClassDefFoundError) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            throw new RuntimeException(e);
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

