/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.docstrings;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.proposals.PyCompletionProposal;
import org.python.pydev.editor.correctionassist.docstrings.AssistDocString;
import org.python.pydev.editor.correctionassist.docstrings.DocstringsPrefPage;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class AssistDocstringCompletionProposal
extends PyCompletionProposal {
    private final String initial;
    private final String delimiter;
    private final String docStringMarker;
    private final String delimiterAndIndent;
    private final String preferredDocstringStyle2;
    private final boolean inFunctionLine;
    private final PySelection.DocstringInfo finalDocstringFromFunction;
    private final String indentation;
    private final FastStringBuffer buf;
    private final List<String> params;

    public AssistDocstringCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, IPyCompletionProposal.ICompareContext compareContext, String initial, String delimiter, String docStringMarker, String delimiterAndIndent, String preferredDocstringStyle2, boolean inFunctionLine, PySelection.DocstringInfo finalDocstringFromFunction, String indentation, FastStringBuffer buf, List<String> params) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, compareContext);
        this.initial = initial;
        this.delimiter = delimiter;
        this.docStringMarker = docStringMarker;
        this.delimiterAndIndent = delimiterAndIndent;
        this.preferredDocstringStyle2 = preferredDocstringStyle2;
        this.inFunctionLine = inFunctionLine;
        this.finalDocstringFromFunction = finalDocstringFromFunction;
        this.indentation = indentation;
        this.buf = buf;
        this.params = params;
    }

    @Override
    public void apply(IDocument document) {
        int iNextLine;
        PySelection ps;
        String nextLine;
        String comp;
        if (this.inFunctionLine) {
            String updatedDocstring = null;
            if (this.finalDocstringFromFunction != null) {
                updatedDocstring = AssistDocString.updatedDocstring(this.finalDocstringFromFunction.string, this.params, this.delimiter, String.valueOf(this.initial) + this.indentation, this.preferredDocstringStyle2);
            }
            if (updatedDocstring != null) {
                this.fReplacementOffset = this.finalDocstringFromFunction.startLiteralOffset;
                this.fReplacementLength = this.finalDocstringFromFunction.endLiteralOffset - this.finalDocstringFromFunction.startLiteralOffset;
                int initialLen = this.buf.length();
                this.buf.clear();
                this.fCursorPosition -= initialLen - this.buf.length();
                this.buf.append(updatedDocstring);
            } else {
                for (String paramName : this.params) {
                    if (!PySelection.isIdentifier((String)paramName)) continue;
                    if (this.preferredDocstringStyle2.equals("G")) {
                        this.buf.append(this.delimiterAndIndent).append(this.indentation).append(paramName).append(":");
                    } else {
                        this.buf.append(this.delimiterAndIndent).append(this.preferredDocstringStyle2).append("param ").append(paramName).append(":");
                    }
                    if (!DocstringsPrefPage.getTypeTagShouldBeGenerated(paramName)) continue;
                    this.buf.append(this.delimiterAndIndent).append(this.preferredDocstringStyle2).append("type ").append(paramName).append(":");
                }
            }
        }
        if (this.finalDocstringFromFunction == null) {
            this.buf.append(this.delimiterAndIndent).append(this.docStringMarker);
        }
        this.fReplacementString = comp = this.buf.toString();
        if (this.finalDocstringFromFunction == null && (nextLine = (ps = new PySelection(document, this.fReplacementOffset)).getLine(iNextLine = ps.getCursorLine() + 1)).trim().equals("pass")) {
            ps.deleteLine(iNextLine);
        }
        super.apply(document);
    }
}

