/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.docstrings;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.editor.correctionassist.docstrings.ParameterNamePrefixListEditor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;

public class DocstringsPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    public static final String P_DOCSTRINGCHARACTER = "DOCSTRING CHARACTER";
    public static final String DEFAULT_P_DOCSTRINGCHARACTER = "'";
    public static final String P_DOCSTRINGSTYLE = "DOCSTRING STYLE";
    public static final String DOCSTRINGSTYLE_SPHINX = ":";
    public static final String DOCSTRINGSTYLE_EPYDOC = "@";
    public static final String DOCSTRINGSTYLE_GOOGLE = "G";
    public static final String DEFAULT_P_DOCSTRINGSTYLE = ":";
    public static final String TYPETAG_GENERATION_NEVER = "Never";
    public static final String TYPETAG_GENERATION_ALWAYS = "Always";
    public static final String TYPETAG_GENERATION_CUSTOM = "Custom";
    public static final String P_TYPETAGGENERATION = "TYPETAGGENERATION";
    public static final String DEFAULT_P_TYPETAGGENERATION = "Never";
    public static final String P_DONT_GENERATE_TYPETAGS = "DONT_GENERATE_TYPETAGS_PREFIXES";
    public static final String DEFAULT_P_DONT_GENERATE_TYPETAGS = "sz\u0000n\u0000f";
    private static final Map<String, String> strToMarker = new HashMap<String, String>();
    public static boolean GENERATE_TYPE_DOCSTRING_ON_TESTS;
    private RadioGroupFieldEditor typeDoctagEditor;

    static {
        strToMarker.put(DEFAULT_P_DOCSTRINGCHARACTER, "'''");
        strToMarker.put("\"", "\"\"\"");
        GENERATE_TYPE_DOCSTRING_ON_TESTS = true;
    }

    public DocstringsPrefPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Docstring preferences");
    }

    public static String getPreferredDocstringCharacter() {
        if (SharedCorePlugin.inTestMode()) {
            return DEFAULT_P_DOCSTRINGCHARACTER;
        }
        return PydevPrefs.getEclipsePreferences().get(P_DOCSTRINGCHARACTER, DEFAULT_P_DOCSTRINGCHARACTER);
    }

    public static String getPreferredDocstringStyle() {
        if (SharedCorePlugin.inTestMode()) {
            return ":";
        }
        return PydevPrefs.getEclipsePreferences().get(P_DOCSTRINGSTYLE, ":");
    }

    public static String getDocstringMarker() {
        String docstringChar = DocstringsPrefPage.getPreferredDocstringCharacter();
        String ret = strToMarker.get(docstringChar);
        if (ret == null) {
            ret = String.valueOf(docstringChar) + docstringChar + docstringChar;
            strToMarker.put(docstringChar, ret);
        }
        return ret;
    }

    public static boolean getTypeTagShouldBeGenerated(String parameterName) {
        if (SharedCorePlugin.inTestMode()) {
            return GENERATE_TYPE_DOCSTRING_ON_TESTS;
        }
        IEclipsePreferences preferences = PydevPrefs.getEclipsePreferences();
        String preference = preferences.get(P_TYPETAGGENERATION, "Never");
        if (preference.equals("Never")) {
            return false;
        }
        if (preference.equals(TYPETAG_GENERATION_ALWAYS)) {
            return true;
        }
        String prefixesString = preferences.get(P_DONT_GENERATE_TYPETAGS, DEFAULT_P_DONT_GENERATE_TYPETAGS);
        StringTokenizer st = new StringTokenizer(prefixesString, "\u0000");
        while (st.hasMoreTokens()) {
            if (!parameterName.startsWith(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        Composite p2 = new Composite(p, 0);
        p2.setLayout((Layout)new RowLayout());
        RadioGroupFieldEditor docstringCharEditor = new RadioGroupFieldEditor(P_DOCSTRINGCHARACTER, "Docstring character", 1, (String[][])new String[][]{{"Quotation mark (\")", "\""}, {"Apostrophe (')", DEFAULT_P_DOCSTRINGCHARACTER}}, p2, true);
        this.addField((FieldEditor)docstringCharEditor);
        RadioGroupFieldEditor docstringStyleEditor = new RadioGroupFieldEditor(P_DOCSTRINGSTYLE, "Docstring style", 1, (String[][])new String[][]{{"Sphinx (:tag name:)", ":"}, {"EpyDoc (@tag name:)", DOCSTRINGSTYLE_EPYDOC}, {"Google (name:)", DOCSTRINGSTYLE_GOOGLE}}, p2, true);
        this.addField((FieldEditor)docstringStyleEditor);
        Group typeDoctagGroup = new Group(p2, 0);
        typeDoctagGroup.setText("Type doctag generation (@type x:...)");
        this.typeDoctagEditor = new RadioGroupFieldEditor(P_TYPETAGGENERATION, "", 1, (String[][])new String[][]{{"&Always", TYPETAG_GENERATION_ALWAYS}, {"&Never", "Never"}, {"&Custom", TYPETAG_GENERATION_CUSTOM}}, (Composite)typeDoctagGroup);
        this.addField((FieldEditor)this.typeDoctagEditor);
        this.addField((FieldEditor)new ParameterNamePrefixListEditor(P_DONT_GENERATE_TYPETAGS, "Don't create for parameters with prefix", (Composite)typeDoctagGroup));
    }

    public void init(IWorkbench workbench) {
    }
}

