/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.proposals.PyCompletionProposal;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class AssistAssignCompletionProposal
extends PyCompletionProposal {
    private ISourceViewer sourceViewer;

    public AssistAssignCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, ISourceViewer sourceViewer, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, compareContext);
        this.sourceViewer = sourceViewer;
    }

    @Override
    public void apply(IDocument document) {
        try {
            int lineOfOffset = document.getLineOfOffset(this.fReplacementOffset);
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            if (SharedCorePlugin.inTestMode()) {
                return;
            }
            int lineOffset = document.getLineOffset(lineOfOffset);
            int lineLength = document.getLineLength(lineOfOffset);
            String lineDelimiter = document.getLineDelimiter(lineOfOffset);
            int lineDelimiterLen = lineDelimiter != null ? lineDelimiter.length() : 0;
            ISourceViewer viewer = this.sourceViewer;
            LinkedModeModel model = new LinkedModeModel();
            LinkedPositionGroup group = new LinkedPositionGroup();
            ProposalPosition proposalPosition = new ProposalPosition(document, this.fReplacementOffset, this.fReplacementString.length() - 3, 0, new ICompletionProposal[0]);
            group.addPosition((LinkedPosition)proposalPosition);
            model.addGroup(group);
            model.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, lineOffset + lineLength - lineDelimiterLen, 0, Integer.MAX_VALUE);
            Runnable r = new Runnable((LinkedModeUI)ui){
                private final /* synthetic */ LinkedModeUI val$ui;
                {
                    this.val$ui = linkedModeUI;
                }

                @Override
                public void run() {
                    this.val$ui.enter();
                }
            };
            RunInUiThread.async((Runnable)r);
        }
        catch (Throwable x) {
            Log.log((Throwable)x);
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        return null;
    }
}

