/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.python.pydev.ast.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.PyTemplateProposal;
import org.python.pydev.editor.correctionassist.IAssistProps;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.ImageCache;

public class AssistSurroundWith
extends AbstractTemplateCodeCompletion
implements IAssistProps {
    public static final String[] SURROUND_WITH_COMPLETIONS = new String[]{"%stry:%s%s%s%sexcept${cursor}:%s%s%sraise", "try..except", "%stry:%s%s%s%sexcept (${RuntimeError}, ), e:%s%s%s${raise}${cursor}", "try..except (RuntimeError, ), e", "%stry:%s%s%s%sfinally:%s%s%s${pass}", "try..finally", "%sif ${True}:%s%s%s%selse:%s%s%s${pass}", "if..else", "%swhile ${True}:%s%s%s%s%s", "while", "%sfor ${item} in ${collection}:%s%s%s%s%s${cursor}", "for", "%sif ${True}:%s%s%s%s%s${cursor}", "if", "%swith ${var}:%s%s%s%s%s${cursor}", "with"};

    @Override
    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposalHandle> l = new ArrayList<ICompletionProposalHandle>();
        String indentation = edit != null ? edit.getIndentPrefs().getIndentationString() : DefaultIndentPrefs.get((IAdaptable)nature).getIndentationString();
        ps.selectCompleteLine();
        String selectedText = ps.getSelectedText();
        selectedText = selectedText.replace("$", "$$");
        List splitInLines = StringUtils.splitInLines((String)selectedText);
        int firstCharPosition = -1;
        int firstCommentCharPosition = -1;
        for (String string : splitInLines) {
            int localFirst;
            String trimmed = string.trim();
            if (trimmed.startsWith("#")) {
                localFirst = PySelection.getFirstCharPosition((String)string);
                if (firstCommentCharPosition == -1) {
                    firstCommentCharPosition = localFirst;
                    continue;
                }
                if (localFirst >= firstCommentCharPosition) continue;
                firstCommentCharPosition = localFirst;
                continue;
            }
            if (trimmed.length() <= 0) continue;
            localFirst = PySelection.getFirstCharPosition((String)string);
            if (firstCharPosition == -1) {
                firstCharPosition = localFirst;
                continue;
            }
            if (localFirst >= firstCharPosition) continue;
            firstCharPosition = localFirst;
        }
        if (firstCharPosition == -1) {
            if (firstCommentCharPosition != -1) {
                firstCharPosition = firstCommentCharPosition;
            } else {
                return l;
            }
        }
        String delimiter = PyAction.getDelimiter(ps.getDoc());
        FastStringBuffer startIndentBuffer = new FastStringBuffer(firstCharPosition + 1);
        startIndentBuffer.appendN(' ', firstCharPosition);
        String startIndent = startIndentBuffer.toString();
        String surroundedCode = selectedText;
        surroundedCode = String.valueOf(indentation) + surroundedCode.replaceAll(delimiter, String.valueOf(delimiter) + indentation);
        IRegion region = ps.getRegion();
        TemplateContext context = null;
        if (edit != null) {
            context = this.createContext(region, ps.getDoc());
        }
        Object[] replace0to3 = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, delimiter, startIndent, indentation, indentation};
        Object[] replace4toEnd = new String[]{startIndent, delimiter, surroundedCode, delimiter, startIndent, indentation};
        int iComp = 0;
        int iRep = 0;
        while (iComp < SURROUND_WITH_COMPLETIONS.length) {
            String comp = SURROUND_WITH_COMPLETIONS[iComp];
            comp = iRep < 4 ? StringUtils.format((String)comp, (Object[])replace0to3) : StringUtils.format((String)comp, (Object[])replace4toEnd);
            l.add(this.createProposal(ps, imageCache, edit, startIndent, region, iComp, comp, context));
            iComp += 2;
            ++iRep;
        }
        return l;
    }

    private ICompletionProposalHandle createProposal(PySelection ps, IImageCache imageCache, IPyEdit edit, final String startIndent, IRegion region, int iComp, String comp, TemplateContext context) {
        Template t = new Template("Surround with", SURROUND_WITH_COMPLETIONS[iComp + 1], "", comp, false);
        if (context != null) {
            PyTemplateProposal proposal = new PyTemplateProposal(t, context, region, ImageCache.asImage((IImageHandle)imageCache.get("icons/template.gif")), 5){

                public String getAdditionalProposalInfo() {
                    return String.valueOf(startIndent) + super.getAdditionalProposalInfo();
                }
            };
            return proposal;
        }
        return CompletionProposalFactory.get().createPyCompletionProposal(comp, region.getOffset(), region.getLength(), 0, 0);
    }

    @Override
    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        return ps.getTextSelection().getLength() > 0;
    }

    public TokensOrProposalsList getCodeCompletionProposals(CompletionRequest request) throws CoreException, BadLocationException {
        throw new RuntimeException("Not implemented: completions should be gotten from the IAssistProps interface.");
    }
}

