/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.core.docutils.StringEscapeUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PyInformationPresenter;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.hover.AbstractPyEditorTextHover;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;

public class PyDocstringTextHover
extends AbstractPyEditorTextHover {
    public static String ID = "org.python.pydev.editor.hover.pyDocstringTextHover";

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        FastStringBuffer buf = new FastStringBuffer();
        if (textViewer instanceof PySourceViewer) {
            PySourceViewer s = (PySourceViewer)textViewer;
            PySelection ps = new PySelection(s.getDocument(), hoverRegion.getOffset() + hoverRegion.getLength());
            this.getDocstringHover(hoverRegion, s, ps, buf);
        }
        return buf.toString();
    }

    @Override
    public boolean isContentTypeSupported(String contentType) {
        boolean pythonCommentOrMultiline = IPythonPartitions.NON_DEFAULT_TYPES_AS_SET.contains(contentType);
        return !pythonCommentOrMultiline;
    }

    private void getDocstringHover(IRegion hoverRegion, PySourceViewer s, PySelection ps, FastStringBuffer buf) {
        RefactoringRequest request;
        CompletionState completionCache = new CompletionState();
        ArrayList selected = new ArrayList();
        PyEdit edit = s.getEdit();
        IPythonNature nature = null;
        try {
            nature = edit.getPythonNature();
            request = new RefactoringRequest(edit.getEditorFile(), ps, (IProgressMonitor)new NullProgressMonitor(), nature, (IPyEdit)edit);
        }
        catch (MisconfigurationException e) {
            return;
        }
        String[] tokenAndQual = null;
        try {
            request.acceptTypeshed = false;
            tokenAndQual = PyRefactoringFindDefinition.findActualDefinition((RefactoringRequest)request, (ICompletionState)completionCache, selected);
            if (tokenAndQual == null || selected.size() == 0) {
                request.acceptTypeshed = true;
                completionCache = new CompletionState();
                tokenAndQual = PyRefactoringFindDefinition.findActualDefinition((RefactoringRequest)request, (ICompletionState)completionCache, selected);
            }
        }
        catch (BadLocationException | CompletionRecursionException e1) {
            Log.log((Throwable)e1);
            buf.append("Unable to compute hover. Details: " + e1.getMessage());
            return;
        }
        FastStringBuffer temp = new FastStringBuffer();
        if (tokenAndQual != null && selected.size() > 0) {
            for (IDefinition d : selected) {
                String str;
                ItemPointer pointer;
                String asPortableString;
                Definition def = (Definition)d;
                SimpleNode astToPrint = null;
                if (def.ast != null) {
                    stmtType stmt;
                    ISimpleNode peek;
                    FastStack scopeStack;
                    astToPrint = def.ast;
                    if ((astToPrint instanceof Name || astToPrint instanceof NameTok) && def.scope != null && (scopeStack = def.scope.getScopeStack()) != null && scopeStack.size() > 0 && (peek = (ISimpleNode)scopeStack.peek()) != null && (stmt = NodeUtils.findStmtForNode((SimpleNode)((SimpleNode)peek), (SimpleNode)astToPrint)) != null) {
                        astToPrint = stmt;
                    }
                    try {
                        astToPrint = astToPrint.createCopy();
                        MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)astToPrint);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                temp = temp.clear();
                if (def.value != null) {
                    if (astToPrint instanceof FunctionDef) {
                        temp.append("def ");
                    } else if (astToPrint instanceof ClassDef) {
                        temp.append("class ");
                    }
                    temp.append("<pydev_hint_bold>");
                    temp.append(def.value);
                    temp.append("</pydev_hint_bold>");
                    temp.append(' ');
                }
                if (def.module != null) {
                    temp.append("Found at: ");
                    temp.append("<pydev_hint_bold>");
                    temp.append(def.module.getName());
                    temp.append("</pydev_hint_bold>");
                    temp.append(PyInformationPresenter.LINE_DELIM);
                }
                if (def.module != null && def.value != null && (asPortableString = (pointer = PyRefactoringFindDefinition.createItemPointer((IDefinition)def)).asPortableString()) != null) {
                    temp.replaceAll("<pydev_hint_bold>", StringUtils.format((String)"<pydev_link pointer=\"%s\">", (Object[])new Object[]{StringEscapeUtils.escapeXml((String)asPortableString)}));
                    temp.replaceAll("</pydev_hint_bold>", "</pydev_link>");
                }
                if ((str = NodeUtils.printAst((IPyEdit)edit, (SimpleNode)astToPrint)) != null && str.trim().length() > 0) {
                    temp.append(PyInformationPresenter.LINE_DELIM);
                    temp.append(str);
                } else {
                    String docstring = d.getDocstring(nature, (ICompletionCache)completionCache);
                    if (docstring != null && docstring.trim().length() > 0) {
                        IIndentPrefs indentPrefs = edit.getIndentPrefs();
                        temp.append(PyStringUtils.fixWhitespaceColumnsToLeftFromDocstring((String)docstring, (String)indentPrefs.getIndentationString()));
                    }
                }
                if (temp.length() <= 0) continue;
                if (buf.length() > 0) {
                    buf.append(PyInformationPresenter.LINE_DELIM);
                }
                buf.append(temp);
            }
        }
    }
}

