/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.hover;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.python.pydev.editor.hover.AbstractPyEditorTextHover;
import org.python.pydev.editor.hover.PyEditorTextHoverDescriptor;

public class PyEditorTextHoverProxy
implements ITextHover,
ITextHoverExtension {
    private PyEditorTextHoverDescriptor fHoverDescriptor;
    private AbstractPyEditorTextHover fHover;
    private String contentType;

    public PyEditorTextHoverProxy(PyEditorTextHoverDescriptor descriptor, String contentType) {
        this.contentType = contentType;
        this.fHoverDescriptor = descriptor;
    }

    public boolean isEnabled() {
        return true;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.ensureHoverCreated() && this.fHover.isContentTypeSupported(this.contentType)) {
            return this.fHover.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ensureHoverCreated() && this.fHover.isContentTypeSupported(this.contentType)) {
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    private boolean ensureHoverCreated() {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return false;
        }
        return this.isCreated() || this.createHover();
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        return this.isCreated();
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof ITextHoverExtension) {
            return this.fHover.getHoverControlCreator();
        }
        return null;
    }
}

