/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.preferences;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;
import org.python.pydev.shared_ui.field_editors.BooleanFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class PydevTypingPreferencesPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PydevTypingPreferencesPage() {
        super(1);
        this.setDescription("Editor");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite initialParent;
        final Composite p = initialParent = this.getFieldEditorParent();
        String preference = "AUTO_LINK";
        String text = "Enable link on automatic parenthesis or literals closing?";
        String tooltip = "Enabling this option will enable the linking mode after a parenthesis or literal is auto-closed.";
        this.addBooleanField(p, preference, text, tooltip);
        this.addBooleanField(p, "AUTO_PAR", "Automatic parentheses insertion", "Enabling this option will enable automatic insertion of parentheses.  Specifically, whenever you hit a brace such as '(', '{', or '[', its related peer will be inserted and your cursor will be placed between the two braces.");
        final BooleanFieldEditorCustom useSmartIndent = this.addBooleanField(p, "SMART_INDENT_PAR", "Use smart-indent?", "");
        final BooleanFieldEditorCustom usePep8Indent = this.addBooleanField(p, "INDENT_AFTER_PAR_AS_PEP8", "    After {, [, ( indent as pep-8.\n", "");
        final LabelFieldEditor labelPep8_1 = new LabelFieldEditor("__UNUSED__00", "            I.e.: add indentation plus additional level right after", p);
        this.addField((FieldEditor)labelPep8_1);
        final LabelFieldEditor labelPep8_2 = new LabelFieldEditor("__UNUSED__01", "", p);
        this.addField((FieldEditor)labelPep8_2);
        final LabelFieldEditor labelPep8_3 = new LabelFieldEditor("__UNUSED__02", "            braces or indent to braces after another token.", p);
        this.addField((FieldEditor)labelPep8_3);
        final BooleanFieldEditorCustom autoIndentToParLevel = this.addBooleanField(p, "AUTO_INDENT_TO_PAR_LEVEL", "    After {, [, ( indent to its level (indents by tabs if unchecked)", "");
        final IntegerFieldEditor indentationLevelsToAddField = new IntegerFieldEditor("AUTO_INDENT_AFTER_PAR_WIDTH", "        Number of indentation levels to add:", p, 1);
        this.addField((FieldEditor)indentationLevelsToAddField);
        final Runnable fixEnablement = new Runnable(){

            @Override
            public void run() {
                boolean useSmartIndentBool = useSmartIndent.getBooleanValue();
                boolean usePep8IndentBool = usePep8Indent.getBooleanValue();
                boolean useAutoIndentToParLevelBool = autoIndentToParLevel.getBooleanValue();
                PydevTypingPreferencesPage.this.fixParensIndentEnablement(p, usePep8Indent, autoIndentToParLevel, indentationLevelsToAddField, labelPep8_1, labelPep8_2, labelPep8_3, useSmartIndentBool, usePep8IndentBool, useAutoIndentToParLevelBool);
            }
        };
        autoIndentToParLevel.getCheckBox(p).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                fixEnablement.run();
            }
        });
        usePep8Indent.getCheckBox(p).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                fixEnablement.run();
            }
        });
        useSmartIndent.getCheckBox(p).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                fixEnablement.run();
            }
        });
        this.fixParensIndentEnablement(p, usePep8Indent, autoIndentToParLevel, indentationLevelsToAddField, labelPep8_1, labelPep8_2, labelPep8_3, this.getPreferenceStore().getBoolean("SMART_INDENT_PAR"), this.getPreferenceStore().getBoolean("INDENT_AFTER_PAR_AS_PEP8"), this.getPreferenceStore().getBoolean("AUTO_INDENT_TO_PAR_LEVEL"));
        this.addBooleanField(p, "AUTO_DEDENT_ELSE", "Automatic dedent of 'else:' and 'elif:'", "");
        this.addBooleanField(p, "AUTO_BRACES", "Automatically skip matching braces when typing", "Enabling this option will enable automatically skipping matching braces if you try to insert them.  For example, if you have the following code:\n\ndef function(self):\n\n...with your cursor before the end parenthesis (after the 'f' in \"self\"), typing a ')' will simply move the cursor to the position after the ')' without inserting a new one.");
        this.addBooleanField(p, "AUTO_COLON", "Automatic colon detection", "Enabling this feature will enable the editor to detect if you are trying to enter a colon which is already there.  Instead of inserting another colon, the editor will simply move your cursor to the next position after the colon.");
        this.addBooleanField(p, "AUTO_LITERALS", "Automatic literal closing", "Automatically close literals (when ' or \" is added, another one is added to close it).");
        this.addBooleanField(p, "AUTO_WRITE_IMPORT_STR", "Automatic insertion of the 'import' string on 'from xxx' ", "Enabling this will allow the editor to automatically write the'import' string when you write a space after you've written 'from xxx '.");
        this.addBooleanField(p, "AUTO_ADD_SELF", "Add 'self' automatically when declaring methods?", "");
        KeySequence down = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.edit.text.moveLineDown");
        KeySequence up = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.edit.text.moveLineUp");
        String downKey = down != null ? down.format() : "Alt+Down";
        String upKey = up != null ? up.format() : "Alt+Up";
        this.addBooleanField(p, "SMART_LINE_MOVE", StringUtils.format((String)"Smart move for line up  (%s) and line down (%s)?.", (Object[])new Object[]{upKey, downKey}), "");
        this.addField((FieldEditor)new LabelFieldEditor("__UNUSED__", "Note: smart move line up/down change applied on editor restart.", p));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private BooleanFieldEditorCustom addBooleanField(Composite p, String preference, String text, String tooltip) {
        BooleanFieldEditorCustom field = new BooleanFieldEditorCustom(preference, text, 0, p);
        this.addField((FieldEditor)field);
        field.setTooltip(p, WrapAndCaseUtils.wrap((String)tooltip, (int)80));
        return field;
    }

    public void init(IWorkbench workbench) {
    }

    private void fixParensIndentEnablement(Composite p, BooleanFieldEditorCustom usePep8Indent, BooleanFieldEditorCustom autoIndentToParLevel, IntegerFieldEditor indentationLevelsToAddField, LabelFieldEditor labelPep8_1, LabelFieldEditor labelPep8_2, LabelFieldEditor labelPep8_3, boolean useSmartIndentBool, boolean usePep8IndentBool, boolean useAutoIndentToParLevelBool) {
        if (!useSmartIndentBool) {
            usePep8Indent.setEnabled(false, p);
            labelPep8_1.setEnabled(false, p);
            labelPep8_2.setEnabled(false, p);
            labelPep8_3.setEnabled(false, p);
            autoIndentToParLevel.setEnabled(false, p);
            indentationLevelsToAddField.setEnabled(false, p);
        } else {
            usePep8Indent.setEnabled(true, p);
            labelPep8_1.setEnabled(true, p);
            labelPep8_2.setEnabled(true, p);
            labelPep8_3.setEnabled(true, p);
            if (usePep8IndentBool) {
                autoIndentToParLevel.setEnabled(false, p);
                indentationLevelsToAddField.setEnabled(false, p);
            } else {
                autoIndentToParLevel.setEnabled(true, p);
                indentationLevelsToAddField.setEnabled(!useAutoIndentToParLevelBool, p);
            }
        }
    }
}

