/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.core.log.Log;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.editor_input.PydevZipFileEditorInput;
import org.python.pydev.shared_ui.editor_input.PydevZipFileStorage;

public class PyOpenEditor {
    public static IEditorPart openEditorInput(IEditorInput file) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new RuntimeException("workbench cannot be null");
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            throw new RuntimeException("activeWorkbenchWindow cannot be null (we have to be in a ui thread for this to work)");
        }
        IWorkbenchPage wp = activeWorkbenchWindow.getActivePage();
        return IDE.openEditor((IWorkbenchPage)wp, (IEditorInput)file, (String)"org.python.pydev.editor.PythonEditor");
    }

    public static IEditorPart doOpenEditor(IFile f) {
        if (f == null) {
            return null;
        }
        try {
            FileEditorInput file = new FileEditorInput(f);
            return PyOpenEditor.openEditorInput((IEditorInput)file);
        }
        catch (Exception e) {
            Log.log((int)4, (String)("Unexpected error opening path " + f.toString()), (Throwable)e);
            return null;
        }
    }

    public static IEditorPart doOpenEditor(File file) {
        String absPath = FileUtils.getFileAbsolutePath((File)file);
        IPath path = Path.fromOSString((String)absPath);
        return PyOpenEditor.doOpenEditor(path, null);
    }

    public static IEditorPart doOpenEditor(IPath path, IProject project) {
        IEditorInput file;
        block4: {
            if (path == null) {
                return null;
            }
            try {
                file = new PySourceLocatorBase().createEditorInput(path, project);
                if (file != null) break block4;
                return null;
            }
            catch (Exception e) {
                Log.log((int)4, (String)("Unexpected error opening path " + path.toString()), (Throwable)e);
                return null;
            }
        }
        return PyOpenEditor.openEditorInput(file);
    }

    public static IEditorPart doOpenEditor(File zipFile, String zipFilePath) {
        if (zipFile == null || zipFilePath == null) {
            return null;
        }
        try {
            PydevZipFileEditorInput file = new PydevZipFileEditorInput(new PydevZipFileStorage(zipFile, zipFilePath));
            return PyOpenEditor.openEditorInput((IEditorInput)file);
        }
        catch (Exception e) {
            Log.log((int)4, (String)("Unexpected error opening zip file " + zipFile.getAbsolutePath() + " - " + zipFilePath), (Throwable)e);
            return null;
        }
    }

    public static IEditorPart doOpenEditorOnFileStore(File fileToOpen) {
        return EditorUtils.openFile((File)fileToOpen);
    }
}

