/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.InterpreterInfoTreeNodeRoot;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.elements.ProjectConfigError;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class ProjectInfoForPackageExplorer {
    private static final Map<IProject, ProjectInfoForPackageExplorer> projectToSourceFolders = new HashMap<IProject, ProjectInfoForPackageExplorer>();
    private static final Object lockProjectToSourceFolders = new Object();
    public final Set<PythonSourceFolder> sourceFolders = new HashSet<PythonSourceFolder>();
    public final List<ProjectConfigError> configErrors = new ArrayList<ProjectConfigError>();
    public IInterpreterInfo interpreterInfo;
    private InterpreterInfoTreeNodeRoot<LabelAndImage> interpreterInfoTreeRoot;
    private static final Map<IProject, UpdatePydevPackageExplorerProblemMarkers> projectToJob = new HashMap<IProject, UpdatePydevPackageExplorerProblemMarkers>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProjectInfoForPackageExplorer getProjectInfo(IProject project) {
        if (project == null) {
            return null;
        }
        Object object = lockProjectToSourceFolders;
        synchronized (object) {
            ProjectInfoForPackageExplorer projectInfo = projectToSourceFolders.get(project);
            if (projectInfo == null) {
                if (!project.isOpen()) {
                    return null;
                }
            } else {
                if (project.isOpen()) return projectInfo;
                projectToSourceFolders.remove(project);
                return null;
            }
            projectInfo = projectToSourceFolders.get(project);
            if (projectInfo != null) return projectInfo;
            projectInfo = new ProjectInfoForPackageExplorer(project);
            projectToSourceFolders.put(project, projectInfo);
            return projectInfo;
        }
    }

    private ProjectInfoForPackageExplorer(IProject project) {
        this.recreateInfo(project);
    }

    public void recreateInfo(IProject project) {
        this.interpreterInfoTreeRoot = null;
        this.configErrors.clear();
        Tuple<List<ProjectConfigError>, IInterpreterInfo> configErrorsAndInfo = this.getConfigErrorsAndInfo(project);
        this.configErrors.addAll((Collection)configErrorsAndInfo.o1);
        this.interpreterInfo = (IInterpreterInfo)configErrorsAndInfo.o2;
    }

    public synchronized InterpreterInfoTreeNodeRoot<LabelAndImage> getProjectInfoTreeStructure(IProject project, Object parent) {
        if (parent == null || this.interpreterInfo == null) {
            return null;
        }
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        if (this.interpreterInfoTreeRoot != null && this.interpreterInfoTreeRoot.getParent().equals(parent) && this.interpreterInfoTreeRoot.interpreterInfo.equals(this.interpreterInfo)) {
            return this.interpreterInfoTreeRoot;
        }
        this.interpreterInfoTreeRoot = null;
        try {
            IImageCache imageCache = SharedUiPlugin.getImageCache();
            String nameForUI = this.interpreterInfo.getNameForUI();
            nameForUI = StringUtils.shorten((String)nameForUI, (int)40);
            this.interpreterInfoTreeRoot = new InterpreterInfoTreeNodeRoot<LabelAndImage>(this.interpreterInfo, (IPythonNature)nature, parent, new LabelAndImage(nameForUI, imageCache.get("icons/python_16x16.png")));
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return null;
        }
        return this.interpreterInfoTreeRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<List<ProjectConfigError>, IInterpreterInfo> getConfigErrorsAndInfo(IProject project) {
        if (project == null || !project.isOpen()) {
            return new Tuple(new ArrayList(), null);
        }
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        if (nature == null) {
            return new Tuple(new ArrayList(), null);
        }
        Tuple<List<ProjectConfigError>, IInterpreterInfo> configErrorsAndInfo = null;
        boolean goodToGo = false;
        int i = 0;
        while (i < 10 && !goodToGo) {
            try {
                configErrorsAndInfo = this.getConfigErrorsAndInfo((IPythonNature)nature, project);
                goodToGo = true;
            }
            catch (PythonNatureWithoutProjectException e1) {
                goodToGo = false;
                ProjectInfoForPackageExplorer projectInfoForPackageExplorer = this;
                synchronized (projectInfoForPackageExplorer) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        if (configErrorsAndInfo == null) {
            return new Tuple(new ArrayList(), null);
        }
        if (nature != null) {
            Object object = lock;
            synchronized (object) {
                UpdatePydevPackageExplorerProblemMarkers job = projectToJob.get(project);
                if (job == null) {
                    job = new UpdatePydevPackageExplorerProblemMarkers("Update pydev package explorer markers for: " + project);
                    projectToJob.put(project, job);
                }
                job.setInfo(project, ((List)configErrorsAndInfo.o1).toArray(new ProjectConfigError[((List)configErrorsAndInfo.o1).size()]));
                job.schedule();
            }
        }
        return configErrorsAndInfo;
    }

    public Tuple<List<ProjectConfigError>, IInterpreterInfo> getConfigErrorsAndInfo(IPythonNature nature, IProject relatedToProject) throws PythonNatureWithoutProjectException {
        if (PythonNature.IN_TESTS) {
            return new Tuple(new ArrayList(), null);
        }
        ArrayList<ProjectConfigError> lst = new ArrayList<ProjectConfigError>();
        if (nature.getProject() == null) {
            lst.add(new ProjectConfigError(relatedToProject, "The configured nature has no associated project."));
        }
        IInterpreterInfo info = null;
        try {
            info = nature.getProjectInterpreter();
            String executableOrJar = info.getExecutableOrJar();
            if ((executableOrJar.contains("/") || executableOrJar.contains("\\")) && !FileUtils.enhancedIsFile((File)new File(executableOrJar))) {
                lst.add(new ProjectConfigError(relatedToProject, "The interpreter configured does not exist in the filesystem: " + executableOrJar));
            }
            ArrayList projectSourcePathSet = new ArrayList(nature.getPythonPathNature().getProjectSourcePathSet(true));
            Collections.sort(projectSourcePathSet);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (String path : projectSourcePathSet) {
                if (path.trim().length() <= 0) continue;
                Path p = new Path(path);
                IResource resource = root.findMember((IPath)p);
                if (resource == null) {
                    relatedToProject.refreshLocal(p.segmentCount(), null);
                    resource = root.findMember((IPath)p);
                }
                if (resource != null && resource.exists()) continue;
                lst.add(new ProjectConfigError(relatedToProject, "Source folder: " + path + " not found"));
            }
            List externalPaths = nature.getPythonPathNature().getProjectExternalSourcePathAsList(true);
            Collections.sort(externalPaths);
            for (String path : externalPaths) {
                if (new File(path).exists()) continue;
                lst.add(new ProjectConfigError(relatedToProject, "Invalid external source folder specified: " + path));
            }
            Tuple versionAndError = nature.getVersionAndError(true);
            if (versionAndError.o2 != null) {
                lst.add(new ProjectConfigError(relatedToProject, StringUtils.replaceNewLines((String)((String)versionAndError.o2), (String)" ")));
            }
        }
        catch (MisconfigurationException e) {
            lst.add(new ProjectConfigError(relatedToProject, StringUtils.replaceNewLines((String)e.getMessage(), (String)" ")));
        }
        catch (Throwable e) {
            lst.add(new ProjectConfigError(relatedToProject, StringUtils.replaceNewLines((String)("Unexpected error:" + e.getMessage()), (String)" ")));
        }
        return new Tuple(lst, (Object)info);
    }

    private static final class UpdatePydevPackageExplorerProblemMarkers
    extends Job {
        private IProject fProject;
        private ProjectConfigError[] fProjectConfigErrors;
        private final Object lockJob = new Object();

        private UpdatePydevPackageExplorerProblemMarkers(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ProjectConfigError[] projectConfigErrors;
            IProject project;
            Object object = this.lockJob;
            synchronized (object) {
                project = this.fProject;
                projectConfigErrors = this.fProjectConfigErrors;
                this.fProject = null;
                this.fProjectConfigErrors = null;
                if (projectConfigErrors == null) {
                    return Status.OK_STATUS;
                }
            }
            ArrayList lst = new ArrayList(projectConfigErrors.length);
            ProjectConfigError[] projectConfigErrorArray = projectConfigErrors;
            int n = projectConfigErrors.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectConfigError error = projectConfigErrorArray[n2];
                try {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("message", error.getLabel());
                    attributes.put("severity", 2);
                    lst.add(attributes);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                ++n2;
            }
            PyMarkerUtils.replaceMarkers((Map[])lst.toArray(new Map[lst.size()]), (IResource)project, (String)"org.python.pydev.PydevProjectErrorMarkers", (boolean)true, (IProgressMonitor)monitor);
            Object object2 = lock;
            synchronized (object2) {
                if (this.fProject == null) {
                    projectToJob.remove(project);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInfo(IProject project, ProjectConfigError[] projectConfigErrors) {
            Object object = this.lockJob;
            synchronized (object) {
                this.fProject = project;
                this.fProjectConfigErrors = projectConfigErrors;
            }
        }
    }
}

