/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.PythonpathZipChildTreeNode;
import org.python.pydev.navigator.ZipStructure;
import org.python.pydev.navigator.elements.ISortedElement;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PythonpathTreeNode
extends TreeNode<LabelAndImage>
implements ISortedElement,
IAdaptable {
    private static final File[] EMPTY_FILES = new File[0];
    public final File file;
    private boolean calculated = false;
    private boolean isDir;
    private boolean isPackage;
    private File[] dirFiles;

    public PythonpathTreeNode(TreeNode<LabelAndImage> parent, File file) {
        this(parent, file, null, false);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == URI.class) {
            return (T)this.file.toURI();
        }
        return null;
    }

    public PythonpathTreeNode(TreeNode<LabelAndImage> parent, File file, IImageHandle icon, boolean isPythonpathRoot) {
        super(parent, null);
        try {
            this.file = file;
            this.isDir = file.isDirectory();
            if (this.isDir) {
                this.dirFiles = file.listFiles();
                if (this.dirFiles == null) {
                    this.dirFiles = EMPTY_FILES;
                }
                if (isPythonpathRoot) {
                    this.isPackage = true;
                } else if (parent instanceof PythonpathTreeNode && ((PythonpathTreeNode)parent).isPackage) {
                    this.isPackage = true;
                }
            }
            if (icon == null) {
                IImageCache imageCache = SharedUiPlugin.getImageCache();
                icon = this.isDir ? (this.isPackage ? imageCache.get("icons/package_obj.gif") : imageCache.get("icons/folder.gif")) : (PythonPathHelper.isValidSourceFile((String)file.getName()) ? imageCache.get("icons/python_file.gif") : imageCache.get("icons/file.gif"));
            }
        }
        finally {
            this.setData(new LabelAndImage(PythonpathTreeNode.getLabel(file, isPythonpathRoot), icon));
        }
    }

    private static String getLabel(File file, boolean isPythonpathRoot) {
        if (isPythonpathRoot) {
            File parent2 = file.getParentFile();
            if (parent2 != null) {
                return String.valueOf(parent2.getName()) + "/" + file.getName();
            }
            return file.getName();
        }
        return file.getName();
    }

    private boolean isZipFile() {
        return this.file.isFile() && FileTypesPreferences.isValidZipFile((String)this.file.getName());
    }

    public boolean hasChildren() {
        return this.isDir && this.dirFiles != null && this.dirFiles.length > 0 || !this.isDir && this.isZipFile();
    }

    @Override
    public int getRank() {
        return this.isDir ? ISortedElement.RANK_PYTHON_FOLDER : ISortedElement.RANK_PYTHON_FILE;
    }

    public synchronized List<TreeNode> getChildren() {
        if (!this.calculated) {
            this.calculated = true;
            if (this.isDir && this.dirFiles != null) {
                File[] fileArray = this.dirFiles;
                int n = this.dirFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    new PythonpathTreeNode(this, file);
                    ++n2;
                }
            } else if (!this.isDir && this.isZipFile()) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(this.file);
                }
                catch (IOException e) {
                    Log.log((Throwable)e);
                }
                if (zipFile != null) {
                    try {
                        ZipStructure zipStructure = new ZipStructure(this.file, zipFile);
                        for (String content : zipStructure.contents("")) {
                            new PythonpathZipChildTreeNode(this, zipStructure, content, null, true);
                        }
                    }
                    finally {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {
                            Log.log((Throwable)e);
                        }
                    }
                }
            }
        }
        return super.getChildren();
    }
}

