/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.navigator.PythonpathTreeNode;
import org.python.pydev.navigator.PythonpathZipChildTreeNode;
import org.python.pydev.navigator.elements.PythonNode;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PyOpenPythonFileAction
extends Action {
    protected final List<IFile> filesSelected = new ArrayList<IFile>();
    protected final List<PythonNode> nodesSelected = new ArrayList<PythonNode>();
    protected final List<Object> containersSelected = new ArrayList<Object>();
    protected final List<PythonpathTreeNode> pythonPathFilesSelected = new ArrayList<PythonpathTreeNode>();
    protected final List<PythonpathZipChildTreeNode> pythonPathZipFilesSelected = new ArrayList<PythonpathZipChildTreeNode>();
    protected final ISelectionProvider provider;

    public PyOpenPythonFileAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        this.setText("Open With Pydev (Python)");
        this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)SharedUiPlugin.getImageCache().getDescriptor("icons/python_file.gif")));
        this.provider = selectionProvider;
    }

    public boolean isEnabled() {
        return true;
    }

    public synchronized void run() {
        this.fillSelections();
        if (this.filesSelected.size() > 0) {
            this.openFiles(this.filesSelected);
        } else if (this.nodesSelected.size() > 0) {
            PythonNode node = this.nodesSelected.iterator().next();
            ParsedItem actualObject = node.getActualObject();
            ASTEntryWithChildren astThis = actualObject.getAstThis();
            if (astThis != null) {
                new PyOpenAction().run(new ItemPointer(node.getPythonFile().getActualObject(), NodeUtils.getNameTokFromNode((SimpleNode)astThis.node)));
            }
        } else if (this.pythonPathZipFilesSelected.size() > 0) {
            this.openFiles(this.pythonPathZipFilesSelected.toArray(new PythonpathZipChildTreeNode[this.pythonPathZipFilesSelected.size()]));
        } else if (this.pythonPathFilesSelected.size() > 0) {
            this.openFiles(this.pythonPathFilesSelected.toArray(new PythonpathTreeNode[this.pythonPathFilesSelected.size()]));
        } else if (this.containersSelected.size() > 0) {
            if (this.provider instanceof TreeViewer) {
                TreeViewer viewer = (TreeViewer)this.provider;
                for (Object container : this.containersSelected) {
                    if (!viewer.isExpandable(container)) continue;
                    viewer.setExpandedState(container, !viewer.getExpandedState(container));
                }
            } else {
                Log.log((String)("Expecting the provider to be a TreeViewer -- it is:" + this.provider.getClass()));
            }
        }
    }

    protected void openFiles(PythonpathZipChildTreeNode[] pythonPathZipFilesSelected) {
        PyOpenAction pyOpenAction = new PyOpenAction();
        PythonpathZipChildTreeNode[] pythonpathZipChildTreeNodeArray = pythonPathZipFilesSelected;
        int n = pythonPathZipFilesSelected.length;
        int n2 = 0;
        while (n2 < n) {
            PythonpathZipChildTreeNode n3 = pythonpathZipChildTreeNodeArray[n2];
            pyOpenAction.run(new ItemPointer((Object)n3.zipStructure.file, new Location(), new Location(), null, n3.zipPath));
            ++n2;
        }
    }

    protected void openFiles(PythonpathTreeNode[] pythonPathFilesSelected) {
        PyOpenAction pyOpenAction = new PyOpenAction();
        PythonpathTreeNode[] pythonpathTreeNodeArray = pythonPathFilesSelected;
        int n = pythonPathFilesSelected.length;
        int n2 = 0;
        while (n2 < n) {
            PythonpathTreeNode n3 = pythonpathTreeNodeArray[n2];
            pyOpenAction.run(new ItemPointer((Object)n3.file));
            ++n2;
        }
    }

    protected void openFiles(List<IFile> filesSelected) {
        for (IFile f : filesSelected) {
            IDE.setDefaultEditor((IFile)f, (String)"org.python.pydev.editor.PythonEditor");
            new PyOpenAction().run(new ItemPointer((Object)f));
        }
    }

    protected synchronized void fillSelections() {
        this.filesSelected.clear();
        this.nodesSelected.clear();
        this.containersSelected.clear();
        this.pythonPathFilesSelected.clear();
        this.pythonPathZipFilesSelected.clear();
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            for (Object element : sSelection) {
                TreeNode node;
                if (element instanceof PythonNode) {
                    this.nodesSelected.add((PythonNode)element);
                    continue;
                }
                if (element instanceof PythonpathZipChildTreeNode) {
                    node = (PythonpathZipChildTreeNode)element;
                    if (node.isDir) {
                        this.containersSelected.add(node);
                        continue;
                    }
                    this.pythonPathZipFilesSelected.add((PythonpathZipChildTreeNode)node);
                    continue;
                }
                if (element instanceof PythonpathTreeNode) {
                    node = (PythonpathTreeNode)element;
                    if (((PythonpathTreeNode)node).file.isFile()) {
                        this.pythonPathFilesSelected.add((PythonpathTreeNode)node);
                        continue;
                    }
                    this.containersSelected.add(node);
                    continue;
                }
                if (!(element instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)element;
                IFile file = (IFile)adaptable.getAdapter(IFile.class);
                if (file != null) {
                    this.filesSelected.add(file);
                    continue;
                }
                IContainer container = (IContainer)adaptable.getAdapter(IContainer.class);
                if (container == null) continue;
                this.containersSelected.add(element);
            }
        }
    }

    public boolean isEnabledForSelectionWithoutContainers() {
        this.fillSelections();
        if (this.filesSelected.size() > 0) {
            for (IFile f : this.filesSelected) {
                String name = f.getName();
                if (name.indexOf(46) != -1) continue;
                return true;
            }
        }
        return this.nodesSelected.size() > 0 || this.pythonPathFilesSelected.size() > 0 || this.pythonPathZipFilesSelected.size() > 0;
    }
}

