/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.process_window;

import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.process_window.ITextWrapper;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.FontUtils;

public class SimpleTerminalEmulator {
    private ITextWrapper output;
    private int cursor = 0;

    public SimpleTerminalEmulator(ITextWrapper textWrapper) {
        this.output = textWrapper;
    }

    public SimpleTerminalEmulator(Composite composite, int flags) {
        this(SimpleTerminalEmulator.createTextWrapper(SimpleTerminalEmulator.createText(composite, flags)));
    }

    private static Text createText(Composite composite, int flags) {
        Text text = new Text(composite, flags);
        text.setFont(new Font((Device)composite.getDisplay(), FontUtils.getFontData((int)0, (boolean)true)));
        return text;
    }

    private static ITextWrapper createTextWrapper(final Text text) {
        return new ITextWrapper(){

            @Override
            public void setText(String string) {
                text.setText(string);
            }

            @Override
            public char[] getTextChars() {
                return text.getTextChars();
            }

            @Override
            public String getText() {
                return text.getText();
            }

            @Override
            public Control getControl() {
                return text;
            }

            @Override
            public void append(String substring) {
                text.append(substring);
            }
        };
    }

    public void clearOutput() {
        this.output.setText("");
        this.cursor = 0;
    }

    public Control getControl() {
        return this.output.getControl();
    }

    public void processText(String contents) {
        List splitInLines = StringUtils.splitInLines((String)contents, (boolean)false);
        for (String line : splitInLines) {
            this.output.append(line);
            this.output.append("\n");
        }
    }
}

