/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.tree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.python.pydev.core.log.Log;
import org.python.pydev.tree.EnabledTreeDragReorder;

class TreeItemDragDataTransfer
extends ByteArrayTransfer {
    private static final TreeItemDragDataTransfer instance = new TreeItemDragDataTransfer();
    private static final String TYPE_NAME = "tree-item-transfer-format" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = TreeItemDragDataTransfer.registerType((String)TYPE_NAME);

    private TreeItemDragDataTransfer() {
    }

    public static TreeItemDragDataTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        EnabledTreeDragReorder.DragData dragData = (EnabledTreeDragReorder.DragData)object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        if (dragData != null) {
            try {
                out.writeUTF(dragData.text);
                out.writeUTF(dragData.image);
                out.close();
                bytes = byteOut.toByteArray();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
            if (bytes != null) {
                super.javaToNative(bytes, transferData);
            }
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                String text = in.readUTF();
                String image = in.readUTF();
                return new EnabledTreeDragReorder.DragData(text, image);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

