/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.ui.TabVariables;
import org.python.pydev.ui.dialogs.ProjectFolderSelectionDialog;
import org.python.pydev.ui.editors.TreeWithAddRemove;

public class PyProjectProperties
extends PropertyPage {
    private IProject project;
    private TreeWithAddRemove treeSourceFolders;
    private TreeWithAddRemove treeExternalLibs;
    private TabVariables tabVariables;
    private TabFolder tabFolder;

    protected Control createContents(Composite p) {
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
        Composite topComp = new Composite(p, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 1;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        topComp.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        Label label = new Label(topComp, 0);
        label.setText("The final PYTHONPATH used for a launch is composed of the paths\ndefined here, joined with the paths defined by the selected interpreter.");
        this.tabFolder = new TabFolder(topComp, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.tabFolder.setLayoutData((Object)gd);
        if (this.project != null) {
            try {
                IPythonPathNature nature = PythonNature.getPythonPathNature((IProject)this.project);
                this.createTabProjectSourceFolders(nature.getProjectSourcePath(false));
                this.createTabExternalSourceFolders(nature.getProjectExternalSourcePath(false));
                this.tabVariables = new TabVariables(this.tabFolder, nature.getVariableSubstitution(false));
                this.createRestoreButton(topComp);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return topComp;
    }

    private void createRestoreButton(Composite topComp) {
        Button button = new Button(topComp, 0);
        button.setText("Force restore internal info");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PyProjectProperties.this.doIt(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTabExternalSourceFolders(String externalSourcePath) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("External Libraries");
        Composite topComp = new Composite((Composite)this.tabFolder, 0);
        tabItem.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/jar_l_obj.gif")));
        topComp.setLayout((Layout)new GridLayout(1, false));
        Label l2 = new Label(topComp, 0);
        l2.setText("External libraries (source folders/zips/jars/eggs) outside of the workspace.\n\nWhen using variables, the final paths resolved must be filesystem absolute.\n\nChanges in external libraries are not monitored, so, the 'Force restore internal info'\nshould be used if an external library changes. ");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        l2.setLayoutData((Object)gd);
        this.treeExternalLibs = new TreeWithAddRemove(topComp, 0, PythonNature.getStrAsStrItems((String)externalSourcePath)){

            @Override
            protected String getImageConstant() {
                return "icons/jar_l_obj.gif";
            }

            @Override
            protected String getButtonLabel(int i) {
                switch (i) {
                    case 0: {
                        return "Add source folder";
                    }
                    case 1: {
                        return "Add zip/jar/egg";
                    }
                    case 2: {
                        return "Add based on variable";
                    }
                }
                throw new AssertionError((Object)("Unexpected: " + i));
            }

            @Override
            protected void handleAddButtonSelected(int nButton) {
                if (nButton == 0) {
                    this.addItemWithDialog(new DirectoryDialog(this.getShell()));
                } else if (nButton == 1) {
                    this.addItemWithDialog(new FileDialog(this.getShell(), 2));
                } else if (nButton == 2) {
                    this.addItemWithDialog(new InputDialog(this.getShell(), "Add path to resolve with variable", "Add path to resolve with variable in the format: ${VARIABLE}", "", null));
                } else {
                    throw new AssertionError((Object)"Unexpected");
                }
            }
        };
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.treeExternalLibs.setLayoutData(data);
        tabItem.setControl((Control)topComp);
    }

    private void createTabProjectSourceFolders(String sourcePath) {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Source Folders");
        tabItem.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/packagefolder_obj.gif")));
        Composite topComp = new Composite((Composite)this.tabFolder, 0);
        topComp.setLayout((Layout)new GridLayout(1, false));
        Label l2 = new Label(topComp, 0);
        l2.setText("Project Source Folders (and zips/jars/eggs).\n\nWhen using variables, the final paths resolved must be workspace-relative.");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        l2.setLayoutData((Object)gd);
        this.treeSourceFolders = new TreeWithAddRemove(topComp, 0, PythonNature.getStrAsStrItems((String)sourcePath)){

            @Override
            protected String getButtonLabel(int i) {
                switch (i) {
                    case 0: {
                        return "Add source folder";
                    }
                    case 1: {
                        return "Add zip/jar/egg";
                    }
                    case 2: {
                        return "Add based on variable";
                    }
                }
                throw new AssertionError((Object)("Unexpected: " + i));
            }

            @Override
            protected void handleAddButtonSelected(int nButton) {
                if (nButton == 0) {
                    this.addItemWithDialog(new ProjectFolderSelectionDialog(this.getShell(), PyProjectProperties.this.project, true, "Choose source folders to add to PYTHONPATH"), PyProjectProperties.this.project);
                } else if (nButton == 1) {
                    this.addItemWithDialog((SelectionDialog)new ResourceSelectionDialog(this.getShell(), (IAdaptable)PyProjectProperties.this.project, "Choose zip/jar/egg to add to PYTHONPATH"), PyProjectProperties.this.project);
                } else if (nButton == 2) {
                    this.addItemWithDialog(new InputDialog(this.getShell(), "Add path to resolve with variable", "Add path to resolve with variable in the format: ${VARIABLE}", "", null));
                } else {
                    throw new AssertionError((Object)"Unexpected");
                }
            }

            @Override
            protected String getImageConstant() {
                return "icons/packagefolder_obj.gif";
            }
        };
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.treeSourceFolders.setLayoutData(data);
        tabItem.setControl((Control)topComp);
    }

    protected void performApply() {
        this.doIt(false);
    }

    public boolean performOk() {
        return this.doIt(false);
    }

    private boolean doIt(boolean force) {
        if (this.project != null) {
            try {
                PythonNature pythonNature;
                boolean changed = false;
                IPythonPathNature pythonPathNature = PythonNature.getPythonPathNature((IProject)this.project);
                String sourcePath = pythonPathNature.getProjectSourcePath(false);
                String externalSourcePath = pythonPathNature.getProjectExternalSourcePath(false);
                Map variableSubstitution = pythonPathNature.getVariableSubstitution(false);
                String newSourcePath = StringUtils.leftAndRightTrim((String)this.treeSourceFolders.getTreeItemsAsStr(), (char)'|');
                String newExternalSourcePath = StringUtils.leftAndRightTrim((String)this.treeExternalLibs.getTreeItemsAsStr(), (char)'|');
                Map<String, String> newVariableSubstitution = this.tabVariables.getTreeItemsAsMap();
                if (this.checkIfShouldBeSet(sourcePath, newSourcePath)) {
                    pythonPathNature.setProjectSourcePath(newSourcePath);
                    changed = true;
                }
                if (this.checkIfShouldBeSet(externalSourcePath, newExternalSourcePath)) {
                    pythonPathNature.setProjectExternalSourcePath(newExternalSourcePath);
                    changed = true;
                }
                if (this.checkIfShouldBeSet(variableSubstitution, newVariableSubstitution)) {
                    pythonPathNature.setVariableSubstitution(newVariableSubstitution);
                    changed = true;
                }
                if ((pythonNature = PythonNature.getPythonNature((IProject)this.project)) != null && (changed || force || pythonNature.getAstManager() == null)) {
                    pythonNature.rebuildPath();
                }
            }
            catch (Exception e) {
                Log.log((int)4, (String)"Unexpected error setting project properties", (Throwable)e);
            }
        }
        return true;
    }

    private boolean checkIfShouldBeSet(Object oldVal, Object newVal) {
        if (oldVal == null) {
            if (newVal == null) {
                return false;
            }
            if (newVal instanceof String) {
                String string = (String)newVal;
                if (string.trim().length() == 0) {
                    return false;
                }
            } else if (newVal instanceof Map) {
                Map map = (Map)newVal;
                if (map.size() == 0) {
                    return false;
                }
            } else {
                throw new AssertionError((Object)("Unexpected: " + newVal));
            }
            return true;
        }
        return !oldVal.equals(newVal);
    }
}

