/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.importsconf;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class ImportsPreferencesPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor fromImportsFirstBooleanEditor;
    private ComboFieldEditor importEngineFieldEditor;
    private BooleanFieldEditor deleteUnusedImportsField;
    private BooleanFieldEditor groupImportsField;
    private BooleanFieldEditor multilineImportsField;
    private BooleanFieldEditor sortIndiviualOnGroupedField;
    private RadioGroupFieldEditor breakImportsInMultilineMode;
    public static final String GROUP_IMPORTS = "GROUP_IMPORTS";
    public static final boolean DEFAULT_GROUP_IMPORTS = true;
    public static final String MULTILINE_IMPORTS = "MULTILINE_IMPORTS";
    public static final boolean DEFAULT_MULTILINE_IMPORTS = true;
    public static final String BREAK_IMPORTS_MODE = "BREAK_IMPORTS_MODE";
    public static final String BREAK_IMPORTS_MODE_ESCAPE = "ESCAPE";
    public static final String BREAK_IMPORTS_MODE_PARENTHESIS = "PARENTHESIS";
    public static final String DEFAULT_BREAK_IMPORTS_MODE = "ESCAPE";
    public static final String IMPORT_ENGINE = "IMPORT_ENGINE";
    public static final String IMPORT_ENGINE_REGULAR_SORT = "IMPORT_ENGINE_REGULAR_SORT";
    public static final String IMPORT_ENGINE_PEP_8 = "IMPORT_ENGINE_PEP_8";
    public static final String IMPORT_ENGINE_ISORT = "IMPORT_ENGINE_ISORT";
    public static final String DEFAULT_IMPORT_ENGINE = "IMPORT_ENGINE_PEP_8";
    public static final String DELETE_UNUSED_IMPORTS = "DELETE_UNUSED_IMPORTS";
    public static final boolean DEFAULT_DELETE_UNUSED_IMPORTS = false;
    public static final String FROM_IMPORTS_FIRST = "FROM_IMPORTS_FIRST";
    public static final boolean DEFAULT_FROM_IMPORTS_FIRST = false;
    public static final String SORT_NAMES_GROUPED = "SORT_NAMES_GROUPED";
    public static final boolean DEFAULT_SORT_NAMES_GROUPED = false;
    public static boolean groupImportsForTests = true;
    public static boolean sortFromImportsFirstForTests = true;
    public static boolean multilineImportsForTests = true;
    public static boolean sortNamesGroupedForTests = false;
    public static String breakImportModeForTests = "PARENTHESIS";
    public static boolean pep8ImportsForTests = true;
    public static boolean deleteUnusedImportsForTests = true;

    public ImportsPreferencesPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Imports Preferences");
    }

    protected void createFieldEditors() {
        final Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new LabelFieldEditor("Label_Info_File_Preferences1", WrapAndCaseUtils.wrap((String)"These setting are used whenever imports are managed in the application\n\n", (int)80), p));
        this.importEngineFieldEditor = new ComboFieldEditor(IMPORT_ENGINE, "Select import sort engine to be used", (String[][])new String[][]{{"Pep 8", "IMPORT_ENGINE_PEP_8"}, {"Regular sort", IMPORT_ENGINE_REGULAR_SORT}, {"isort", IMPORT_ENGINE_ISORT}}, p);
        this.addFieldWithToolTip(this.importEngineFieldEditor, p, "Select which import engine should be used to sort the imports when such an operation is requested.");
        this.deleteUnusedImportsField = new BooleanFieldEditor(DELETE_UNUSED_IMPORTS, WrapAndCaseUtils.wrap((String)"Delete unused imports?", (int)80), p);
        this.addFieldWithToolTip(this.deleteUnusedImportsField, p, "Simple unused imports as reported by the code analysis are deleted. This can be configured to ignore certain files, and individual warnings can be surpressed.");
        this.groupImportsField = new BooleanFieldEditor(GROUP_IMPORTS, "Combine 'from' imports when possible?", p);
        this.addField((FieldEditor)this.groupImportsField);
        this.fromImportsFirstBooleanEditor = new BooleanFieldEditor(FROM_IMPORTS_FIRST, "Sort 'from' imports before 'import' imports?", p);
        this.addField((FieldEditor)this.fromImportsFirstBooleanEditor);
        this.multilineImportsField = new BooleanFieldEditor(MULTILINE_IMPORTS, WrapAndCaseUtils.wrap((String)"Allow multiline imports when the import size would exceed the print margin?", (int)80), p);
        this.addField((FieldEditor)this.multilineImportsField);
        this.sortIndiviualOnGroupedField = new BooleanFieldEditor(SORT_NAMES_GROUPED, WrapAndCaseUtils.wrap((String)"Sort individual names on grouped imports?", (int)80), p);
        this.addField((FieldEditor)this.sortIndiviualOnGroupedField);
        this.breakImportsInMultilineMode = new RadioGroupFieldEditor(BREAK_IMPORTS_MODE, "How to break imports in multiline?", 1, (String[][])new String[][]{{"Use escape char", "ESCAPE"}, {"Use parenthesis", BREAK_IMPORTS_MODE_PARENTHESIS}}, p);
        this.addField((FieldEditor)this.breakImportsInMultilineMode);
        this.updateEnablement(p, PyDevUiPrefs.getPreferenceStore().getString(IMPORT_ENGINE));
        Combo importEngineCombo = this.importEngineFieldEditor.getCombo();
        importEngineCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportsPreferencesPage.this.updateEnablement(p, ImportsPreferencesPage.this.importEngineFieldEditor.getComboValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)new LinkFieldEditor("link_saveactions", "\nNote: view <a>save actions</a> to automatically sort imports on save.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.editor.saveactions.PydevSaveActionsPrefPage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)ImportsPreferencesPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private void updateEnablement(Composite p, String importEngine) {
        switch (importEngine) {
            case "IMPORT_ENGINE_PEP_8": {
                this.fromImportsFirstBooleanEditor.setEnabled(true, p);
                this.deleteUnusedImportsField.setEnabled(true, p);
                this.groupImportsField.setEnabled(true, p);
                this.multilineImportsField.setEnabled(true, p);
                this.sortIndiviualOnGroupedField.setEnabled(true, p);
                this.breakImportsInMultilineMode.setEnabled(true, p);
                break;
            }
            case "IMPORT_ENGINE_REGULAR_SORT": {
                this.fromImportsFirstBooleanEditor.setEnabled(false, p);
                this.deleteUnusedImportsField.setEnabled(true, p);
                this.groupImportsField.setEnabled(true, p);
                this.multilineImportsField.setEnabled(true, p);
                this.sortIndiviualOnGroupedField.setEnabled(true, p);
                this.breakImportsInMultilineMode.setEnabled(true, p);
                break;
            }
            case "IMPORT_ENGINE_ISORT": {
                this.fromImportsFirstBooleanEditor.setEnabled(false, p);
                this.deleteUnusedImportsField.setEnabled(false, p);
                this.groupImportsField.setEnabled(false, p);
                this.multilineImportsField.setEnabled(false, p);
                this.sortIndiviualOnGroupedField.setEnabled(false, p);
                this.breakImportsInMultilineMode.setEnabled(false, p);
            }
        }
    }

    private void addFieldWithToolTip(BooleanFieldEditor editor, Composite p, String tip) {
        this.addField((FieldEditor)editor);
        editor.getDescriptionControl(p).setToolTipText(tip);
    }

    private void addFieldWithToolTip(ComboFieldEditor editor, Composite p, String tip) {
        this.addField((FieldEditor)editor);
        editor.getLabelControl(p).setToolTipText(tip);
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean getGroupImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return groupImportsForTests;
        }
        return PyScopedPreferences.getBoolean((String)GROUP_IMPORTS, (IAdaptable)projectAdaptable);
    }

    public static boolean getSortFromImportsFirst(IAdaptable projectAdaptable) {
        if (PydevPlugin.getDefault() == null) {
            return sortFromImportsFirstForTests;
        }
        return PyScopedPreferences.getBoolean((String)FROM_IMPORTS_FIRST, (IAdaptable)projectAdaptable);
    }

    public static boolean getMultilineImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return multilineImportsForTests;
        }
        return PyScopedPreferences.getBoolean((String)MULTILINE_IMPORTS, (IAdaptable)projectAdaptable);
    }

    public static boolean getSortNamesGrouped(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return sortNamesGroupedForTests;
        }
        return PyScopedPreferences.getBoolean((String)SORT_NAMES_GROUPED, (IAdaptable)projectAdaptable);
    }

    public static String getBreakIportMode(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return breakImportModeForTests;
        }
        return PyScopedPreferences.getString((String)BREAK_IMPORTS_MODE, (IAdaptable)projectAdaptable);
    }

    public static String getImportEngine(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            if (pep8ImportsForTests) {
                return "IMPORT_ENGINE_PEP_8";
            }
            return IMPORT_ENGINE_REGULAR_SORT;
        }
        String importEngine = PyScopedPreferences.getString((String)IMPORT_ENGINE, (IAdaptable)projectAdaptable);
        if (importEngine == null) {
            importEngine = "IMPORT_ENGINE_PEP_8";
        }
        switch (importEngine) {
            case "IMPORT_ENGINE_ISORT": 
            case "IMPORT_ENGINE_PEP_8": 
            case "IMPORT_ENGINE_REGULAR_SORT": {
                return importEngine;
            }
        }
        return "IMPORT_ENGINE_PEP_8";
    }

    public static boolean getDeleteUnusedImports(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return deleteUnusedImportsForTests;
        }
        return PyScopedPreferences.getBoolean((String)DELETE_UNUSED_IMPORTS, (IAdaptable)projectAdaptable);
    }
}

