/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.python.pydev.ast.interpreter_managers.IInterpreterProvider;
import org.python.pydev.ast.interpreter_managers.IInterpreterProviderFactory;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.progress.AsynchronousProgressMonitorWrapper;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.InterpreterConfigHelpers;
import org.python.pydev.ui.pythonpathconf.NameAndExecutable;
import org.python.pydev.ui.pythonpathconf.ObtainInterpreterInfoOperation;

public class AutoConfigMaker {
    private IInterpreterProviderFactory.InterpreterType interpreterType;
    private IInterpreterManager interpreterManager;
    private boolean advanced;
    private PrintWriter logger;
    private CharArrayWriter charWriter;
    private Map<String, IInterpreterInfo> nameToInfo;

    public AutoConfigMaker(IInterpreterProviderFactory.InterpreterType interpreterType, boolean advanced, PrintWriter logger, Map<String, IInterpreterInfo> nameToInfo) {
        this.interpreterType = interpreterType;
        this.nameToInfo = nameToInfo;
        switch (interpreterType) {
            case JYTHON: {
                this.interpreterManager = InterpreterManagersAPI.getJythonInterpreterManager((boolean)true);
                break;
            }
            case IRONPYTHON: {
                this.interpreterManager = InterpreterManagersAPI.getIronpythonInterpreterManager((boolean)true);
                break;
            }
            default: {
                this.interpreterManager = InterpreterManagersAPI.getPythonInterpreterManager((boolean)true);
            }
        }
        this.advanced = advanced;
        if (logger != null) {
            this.charWriter = null;
            this.logger = logger;
        } else {
            this.charWriter = new CharArrayWriter();
            this.logger = new PrintWriter(this.charWriter);
        }
    }

    public boolean autoConfigSingleApply(JobChangeAdapter onConfigComplete) {
        if (this.interpreterManager.getInterpreterInfos().length != 0) {
            return false;
        }
        ObtainInterpreterInfoOperation operation = this.autoConfigSearch();
        if (operation == null) {
            return false;
        }
        return AutoConfigMaker.applyOperation(onConfigComplete, operation, this.interpreterManager, this.charWriter, true);
    }

    public static boolean applyOperation(JobChangeAdapter onConfigComplete, ObtainInterpreterInfoOperation operation, IInterpreterManager interpreterManager, CharArrayWriter charWriter, boolean replaceExistingInfos) {
        try {
            InterpreterInfo interpreterInfo = operation.result.makeCopy();
            HashSet<String> interpreterNamesToRestore = new HashSet<String>(Arrays.asList(operation.result.executableOrJar));
            Job applyOperationJob = new Job("Configure Interpreter", (IInterpreterInfo)interpreterInfo, replaceExistingInfos, interpreterManager, interpreterNamesToRestore){
                private final /* synthetic */ IInterpreterInfo val$interpreterInfo;
                private final /* synthetic */ boolean val$replaceExistingInfos;
                private final /* synthetic */ IInterpreterManager val$interpreterManager;
                private final /* synthetic */ Set val$interpreterNamesToRestore;
                {
                    this.val$interpreterInfo = iInterpreterInfo;
                    this.val$replaceExistingInfos = bl;
                    this.val$interpreterManager = iInterpreterManager;
                    this.val$interpreterNamesToRestore = set;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    monitor = new AsynchronousProgressMonitorWrapper(monitor);
                    PyDialogHelpers.enableAskInterpreterStep(false);
                    monitor.beginTask("Restoring PYTHONPATH", -1);
                    try {
                        try {
                            IInterpreterInfo[] infos = new IInterpreterInfo[]{this.val$interpreterInfo};
                            if (!this.val$replaceExistingInfos) {
                                infos = (IInterpreterInfo[])ArrayUtils.concatArrays((Object[][])new IInterpreterInfo[][]{this.val$interpreterManager.getInterpreterInfos(), infos});
                            }
                            this.val$interpreterManager.setInfos(infos, this.val$interpreterNamesToRestore, monitor);
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                            String errorMsg = "Error configuring the chosen interpreter.\nMake sure the file containing the interpreter did not get corrupted during the configuration process.";
                            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Interpreter configuration failure", (String)errorMsg, (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"See error log for details.", (Throwable)e));
                            IStatus iStatus = Status.CANCEL_STATUS;
                            monitor.done();
                            PyDialogHelpers.enableAskInterpreterStep(true);
                            return iStatus;
                        }
                    }
                    finally {
                        monitor.done();
                        PyDialogHelpers.enableAskInterpreterStep(true);
                    }
                    return Status.OK_STATUS;
                }
            };
            applyOperationJob.setUser(true);
            if (onConfigComplete != null) {
                applyOperationJob.addJobChangeListener((IJobChangeListener)onConfigComplete);
            }
            applyOperationJob.schedule();
            return true;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            String errorMsg = "Error getting info on the interpreter selected by the auto-configurer.\nTry manual configuration instead.\n\nCommon reasons include:\n\n- Using an unsupported version\n  (Python and Jython require at least version 2.1 and IronPython 2.6).\n\n- Specifying an invalid interpreter\n  (usually a link to the actual interpreter on Mac or Linux)";
            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Unable to get info on the interpreter.", (String)errorMsg, (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"See error log for details.", (Throwable)e));
            return false;
        }
        finally {
            if (charWriter != null) {
                Log.logInfo((String)charWriter.toString());
            }
        }
    }

    public ObtainInterpreterInfoOperation autoConfigSearch() {
        List<PossibleInterpreter> possibleInterpreters = this.getPossibleInterpreters();
        return this.autoConfigSearch(possibleInterpreters);
    }

    private ObtainInterpreterInfoOperation autoConfigSearch(List<PossibleInterpreter> possibleInterpreters) {
        PossibleInterpreter selectedFromPossible = null;
        Tuple3<PossibleInterpreter, Boolean, List<Exception>> r = this.removeInvalidPossibles(possibleInterpreters);
        selectedFromPossible = (PossibleInterpreter)r.o1;
        boolean foundDuplicate = (Boolean)r.o2;
        List exceptions = (List)r.o3;
        if (possibleInterpreters.size() > 0) {
            if (selectedFromPossible == null) {
                if (this.advanced && possibleInterpreters.size() > 1) {
                    selectedFromPossible = this.promptToSelectInterpreter(possibleInterpreters);
                    if (selectedFromPossible == null) {
                        return null;
                    }
                } else {
                    selectedFromPossible = possibleInterpreters.get(0);
                }
            }
            return selectedFromPossible.getOperation();
        }
        this.showNothingToConfigureError(foundDuplicate, exceptions);
        return null;
    }

    private PossibleInterpreter promptToSelectInterpreter(List<PossibleInterpreter> possibleInterpreters) {
        ListDialog listDialog = new ListDialog(EditorUtils.getShell());
        listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/python_16x16.png"));
            }

            public String getText(Object element) {
                PossibleInterpreter possible = (PossibleInterpreter)element;
                return possible.getExecutableOrJar();
            }
        });
        listDialog.setInput((Object)possibleInterpreters.toArray());
        listDialog.setMessage("Multiple possible interpreters are available.\nPlease select which one you want to install and configure.");
        if (listDialog.open() == 0) {
            Object[] result = listDialog.getResult();
            return (PossibleInterpreter)result[0];
        }
        return null;
    }

    private Tuple3<PossibleInterpreter, Boolean, List<Exception>> removeInvalidPossibles(List<PossibleInterpreter> possibleInterpreters) {
        boolean foundDuplicate = false;
        LinkedListWarningOnSlowOperations exceptions = new LinkedListWarningOnSlowOperations();
        Iterator<PossibleInterpreter> iterator = possibleInterpreters.iterator();
        while (iterator.hasNext()) {
            PossibleInterpreter possibleInterpreter = iterator.next();
            Boolean validStatus = null;
            try {
                validStatus = possibleInterpreter.isValid();
                if (!validStatus.booleanValue()) {
                    foundDuplicate = true;
                    throw new Exception("Duplicate interpreter.");
                }
            }
            catch (Exception e) {
                if (validStatus == null) {
                    exceptions.add(e);
                }
                if (this.advanced && e.getMessage().startsWith("The interpreter's standard libraries (typically in a Lib/ folder) are missing: ")) continue;
                iterator.remove();
                continue;
            }
            if (this.advanced || possibleInterpreter.needInstall()) continue;
            return new Tuple3((Object)possibleInterpreter, (Object)foundDuplicate, (Object)exceptions);
        }
        return new Tuple3(null, (Object)foundDuplicate, (Object)exceptions);
    }

    private void showNothingToConfigureError(boolean foundDuplicate, List<Exception> exceptions) {
        String typeSpecificMessage;
        String errorMsg = "Auto-configurer could not find a valid interpreter" + (foundDuplicate ? " that has not already been configured" : "") + ".\n" + "Please manually configure a new interpreter instead.";
        switch (this.interpreterType) {
            case PYTHON: {
                typeSpecificMessage = "\n\nNote: the system environment variables that are used when auto-searching for a Jython interpreter are the following:\n- PATH\n- PYTHONHOME / PYTHON_HOME";
                break;
            }
            case JYTHON: {
                typeSpecificMessage = "\n\nNote: the system environment variables that are used when auto-searching for a Jython interpreter are the following:\n- PATH\n- PYTHONHOME / PYTHON_HOME\n- JYTHONHOME / JYTHON_HOME";
                break;
            }
            default: {
                typeSpecificMessage = "";
            }
        }
        String message = exceptions.size() > 0 ? "Errors getting info on discovered interpreter(s).\nSee error log for details." : (foundDuplicate ? "All interpreters found are already being used." : "No interpreters were found.\nMake sure an interpreter is in the system PATH.");
        String dialogTitle = "Unable to auto-configure.";
        if (exceptions.size() > 0) {
            IStatus[] children = new IStatus[exceptions.size()];
            int i = 0;
            while (i < exceptions.size()) {
                Exception exception = exceptions.get(i);
                children[i] = SharedCorePlugin.makeStatus((int)4, null, (Throwable)exception);
                ++i;
            }
            MultiStatus multiStatus = new MultiStatus(PydevPlugin.getPluginID(), 4, children, message, null);
            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)dialogTitle, (String)(String.valueOf(errorMsg) + typeSpecificMessage), (IStatus)multiStatus);
        } else {
            Status status = SharedCorePlugin.makeStatus((int)4, (String)message, null);
            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)dialogTitle, (String)(String.valueOf(errorMsg) + typeSpecificMessage), (IStatus)status);
        }
    }

    private List<PossibleInterpreter> getPossibleInterpreters() {
        List<IInterpreterProvider> providers = this.getAllProviders();
        ArrayList<PossibleInterpreter> possibleInterpreters = new ArrayList<PossibleInterpreter>(providers.size());
        for (IInterpreterProvider provider : providers) {
            PossibleInterpreter possibleInterpreter = new PossibleInterpreter(provider);
            possibleInterpreters.add(possibleInterpreter);
        }
        return possibleInterpreters;
    }

    private List<IInterpreterProvider> getAllProviders() {
        final ArrayList<IInterpreterProvider> providers = new ArrayList<IInterpreterProvider>();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_provider");
        for (final IInterpreterProviderFactory providerFactory : participants) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    IInterpreterProvider[] ips = providerFactory.getInterpreterProviders(AutoConfigMaker.this.interpreterType);
                    if (ips != null) {
                        providers.addAll(Arrays.asList(ips));
                    }
                }
            });
        }
        return providers;
    }

    private class PossibleInterpreter {
        private IInterpreterProvider provider;
        private ObtainInterpreterInfoOperation quickOperation;
        private NameAndExecutable interpreterNameAndExecutable;

        public PossibleInterpreter(IInterpreterProvider provider) {
            this.provider = provider;
        }

        public boolean isValid() throws Exception {
            if (this.needInstall()) {
                return true;
            }
            if (InterpreterConfigHelpers.getDuplicatedMessageError(null, this.getNameAndExecutable().o2, AutoConfigMaker.this.nameToInfo) != null) {
                return false;
            }
            this.quickOperation = this.createOperation(false, false);
            return true;
        }

        private ObtainInterpreterInfoOperation createOperation(boolean advanced, boolean showErrors) throws Exception {
            return InterpreterConfigHelpers.tryInterpreter(this.getNameAndExecutable(), AutoConfigMaker.this.interpreterManager, !advanced, showErrors, AutoConfigMaker.this.logger, EditorUtils.getShell());
        }

        private NameAndExecutable getNameAndExecutable() throws Exception {
            String name;
            if (this.interpreterNameAndExecutable != null) {
                return this.interpreterNameAndExecutable;
            }
            String executable = this.provider.getExecutableOrJar();
            if (executable != null && executable.trim().length() > 0) {
                name = this.provider.getName();
                if (name == null) {
                    name = executable;
                }
                if (AutoConfigMaker.this.nameToInfo != null) {
                    name = InterpreterConfigHelpers.getUniqueInterpreterName(name, AutoConfigMaker.this.nameToInfo);
                }
            } else {
                throw new Exception("Provider is invalid because it returned null from getExecutableOrJar()");
            }
            this.interpreterNameAndExecutable = new NameAndExecutable(name, executable);
            return this.interpreterNameAndExecutable;
        }

        public ObtainInterpreterInfoOperation getOperation() {
            if (this.needInstall()) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        PossibleInterpreter.this.provider.runInstall();
                    }
                });
                if (this.needInstall()) {
                    return null;
                }
                this.interpreterNameAndExecutable = null;
            }
            if (!AutoConfigMaker.this.advanced && this.quickOperation != null) {
                return this.quickOperation;
            }
            try {
                return this.createOperation(AutoConfigMaker.this.advanced, true);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return null;
            }
        }

        public boolean needInstall() {
            return !this.provider.isInstalled();
        }

        public String getExecutableOrJar() {
            return this.provider.getExecutableOrJar();
        }
    }
}

