/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.core.IInterpreterManager;

public class ObtainInterpreterInfoOperation
implements IRunnableWithProgress {
    public InterpreterInfo result;
    public String file;
    public Exception e;
    private PrintWriter logger;
    private IInterpreterManager interpreterManager;
    private boolean autoSelect;

    public ObtainInterpreterInfoOperation(String file2, PrintWriter logger, IInterpreterManager interpreterManager, boolean autoSelect) {
        this.file = file2;
        this.logger = logger;
        this.interpreterManager = interpreterManager;
        this.autoSelect = autoSelect;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor = new OperationMonitor((IProgressMonitor)monitor, this.logger);
        monitor.beginTask("Getting libs", 100);
        try {
            InterpreterInfo interpreterInfo = (InterpreterInfo)this.interpreterManager.createInterpreterInfo(this.file, monitor, !this.autoSelect);
            if (interpreterInfo != null) {
                this.result = interpreterInfo;
            }
        }
        catch (Exception e) {
            this.logger.println("Exception detected: " + e.getMessage());
            this.e = e;
        }
        monitor.done();
    }

    static class OperationMonitor
    extends ProgressMonitorWrapper {
        private PrintWriter logger;

        protected OperationMonitor(IProgressMonitor monitor, PrintWriter logger) {
            super(monitor);
            this.logger = logger;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.logger.print("- Beggining task:");
            this.logger.print(name);
            this.logger.print(" totalWork:");
            this.logger.println(totalWork);
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.logger.print("- Setting task name:");
            this.logger.println(name);
        }

        public void subTask(String name) {
            super.subTask(name);
            this.logger.print("- Sub Task:");
            this.logger.println(name);
        }
    }
}

