/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.plugin.nature.PipenvHelper;
import org.python.pydev.shared_ui.field_editors.FileFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.ProjectDirectoryFieldEditorCustom;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.ValidationFailedException;

public class PipenvDialog
extends Dialog {
    private FileFieldEditor fileFieldEditor;
    private Combo comboBaseInterpreter;
    private IInterpreterInfo[] interpreterInfos;
    private ProjectDirectoryFieldEditorCustom projectLocationFieldEditor;
    private Text errorMessageText;
    private String defaultPipenvLocation;
    private String defaultProjectLocation;
    private String projectLocation;
    private String pipenvLocation;
    private IInterpreterInfo baseInterpreter;
    private String dialogTitle;
    private boolean showBaseInterpreter;

    public PipenvDialog(Shell parentShell, IInterpreterInfo[] interpreterInfos, String defaultPipenvLocation, String defaultProjectLocation, IInterpreterManager interpreterManager, String dialogTitle, boolean showBaseInterpreter) {
        super(parentShell);
        this.showBaseInterpreter = showBaseInterpreter;
        this.dialogTitle = dialogTitle;
        this.setShellStyle(3184);
        Assert.isTrue((interpreterInfos != null ? 1 : 0) != 0, (String)"IInterpreterInfo must not be null.");
        Assert.isTrue((interpreterInfos.length > 0 ? 1 : 0) != 0, (String)"Must pass at least one IInterpreterInfo.");
        this.interpreterInfos = interpreterInfos;
        if (defaultPipenvLocation == null) {
            defaultPipenvLocation = PipenvHelper.searchDefaultPipenvLocation((IInterpreterInfo)interpreterInfos[0], (IInterpreterManager)interpreterManager);
        }
        this.defaultPipenvLocation = defaultPipenvLocation == null ? "" : defaultPipenvLocation;
        this.defaultProjectLocation = defaultProjectLocation == null ? "" : defaultProjectLocation;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(top, 0);
        composite.setLayoutData((Object)this.createGridData(1));
        int numberOfColumns = 2;
        this.projectLocationFieldEditor = new ProjectDirectoryFieldEditorCustom("unused", "Project location", composite);
        this.projectLocationFieldEditor.fillIntoGrid(composite, numberOfColumns);
        this.projectLocationFieldEditor.setChangeButtonText("...");
        this.projectLocationFieldEditor.setStringValue(this.defaultProjectLocation);
        this.projectLocationFieldEditor.setEmptyStringAllowed(false);
        if (this.showBaseInterpreter) {
            Label label = new Label(composite, 0);
            label.setText("Base Interpreter:");
            label.setLayoutData((Object)this.createGridData(numberOfColumns));
            this.comboBaseInterpreter = new Combo(composite, 8);
            this.comboBaseInterpreter.setLayoutData((Object)this.createGridData(numberOfColumns));
            IInterpreterInfo[] iInterpreterInfoArray = this.interpreterInfos;
            int n = this.interpreterInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInfo info = iInterpreterInfoArray[n2];
                this.comboBaseInterpreter.add(info.getNameForUI());
                this.comboBaseInterpreter.setData(info.getNameForUI(), (Object)info);
                ++n2;
            }
            this.comboBaseInterpreter.setText(this.interpreterInfos[0].getNameForUI());
        }
        this.fileFieldEditor = new FileFieldEditorCustom("unused", "pipenv executable", composite);
        this.fileFieldEditor.fillIntoGrid(composite, numberOfColumns);
        this.fileFieldEditor.setChangeButtonText("...");
        this.fileFieldEditor.setEmptyStringAllowed(false);
        this.fileFieldEditor.setStringValue(this.defaultPipenvLocation);
        this.errorMessageText = new Text(composite, 8);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.errorMessageText.setForeground(this.errorMessageText.getDisplay().getSystemColor(3));
        GridData gridData = this.createGridData(numberOfColumns);
        gridData.heightHint = 60;
        this.errorMessageText.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(numberOfColumns, false));
        return top;
    }

    protected void okPressed() {
        try {
            int openQuestionWithChoices;
            File file;
            this.errorMessageText.setText("");
            String stringValue = this.projectLocationFieldEditor.getStringValue();
            if (stringValue != null && !stringValue.trim().isEmpty() && !(file = new File(stringValue.trim())).exists() && (openQuestionWithChoices = PyDialogHelpers.openQuestionWithChoices("Directory does not exist", "Directory " + stringValue.trim() + " does not exist.\n\nHow do you want to proceed?", "Create directory", "Don't create directory")) == 0) {
                file.mkdirs();
                this.projectLocationFieldEditor.refreshValidState();
            }
            this.projectLocation = this.check("Project location", (StringButtonFieldEditor)this.projectLocationFieldEditor);
            this.pipenvLocation = this.check("pipenv location", (StringButtonFieldEditor)this.fileFieldEditor);
            PipenvHelper.storeDefaultPipenvLocation((String)this.pipenvLocation);
            if (this.showBaseInterpreter) {
                this.baseInterpreter = (IInterpreterInfo)this.comboBaseInterpreter.getData(this.comboBaseInterpreter.getText());
            }
            this.additionalValidation();
            super.okPressed();
        }
        catch (ValidationFailedException validationFailedException) {
            // empty catch block
        }
    }

    protected void additionalValidation() throws ValidationFailedException {
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public String getPipenvLocation() {
        return this.pipenvLocation;
    }

    public IInterpreterInfo getBaseInterpreter() {
        return this.baseInterpreter;
    }

    private String check(String title, StringButtonFieldEditor fileFieldEditor) throws ValidationFailedException {
        String errorMessage;
        if (!fileFieldEditor.isValid() && (errorMessage = fileFieldEditor.getErrorMessage()) != null && !errorMessage.isEmpty()) {
            String msg = String.valueOf(title) + ": " + errorMessage;
            this.setErrorMessage(msg);
            throw new ValidationFailedException();
        }
        return fileFieldEditor.getStringValue();
    }

    protected void setErrorMessage(String msg) {
        this.errorMessageText.setText(msg);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = this.getOkButtonText();
        }
        Button button = super.createButton(parent, id, label, defaultButton);
        return button;
    }

    protected String getOkButtonText() {
        return "Create Pipenv interpreter";
    }

    private GridData createGridData(int horizontalSpan) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = horizontalSpan;
        gridData.widthHint = 500;
        return gridData;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        PipenvDialog dialog = new PipenvDialog(shell, new IInterpreterInfo[0], null, null, null, "New Pipenv interpreter", true);
        dialog.open();
    }
}

