/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf.conda;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.ast.interpreter_managers.PyDevCondaPreferences;
import org.python.pydev.shared_ui.field_editors.FileFieldEditorCustom;
import org.python.pydev.ui.pythonpathconf.ValidationFailedException;

public class CondaConfigDialog
extends Dialog {
    private FileFieldEditor fileFieldEditor;
    private Text errorMessageText;
    private String condaExecLocation;

    public CondaConfigDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3184);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select conda executable");
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(top, 0);
        composite.setLayoutData((Object)this.createGridData(1));
        int numberOfColumns = 2;
        this.fileFieldEditor = new FileFieldEditorCustom("unused", "Conda executable", composite);
        this.fileFieldEditor.fillIntoGrid(composite, numberOfColumns);
        this.fileFieldEditor.setChangeButtonText("...");
        this.fileFieldEditor.setEmptyStringAllowed(false);
        String path = "";
        File executable = PyDevCondaPreferences.getExecutable();
        if (executable != null) {
            path = executable.getAbsolutePath();
        }
        this.fileFieldEditor.setStringValue(path);
        this.errorMessageText = new Text(composite, 8);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.errorMessageText.setForeground(this.errorMessageText.getDisplay().getSystemColor(3));
        GridData gridData = this.createGridData(numberOfColumns);
        gridData.heightHint = 30;
        this.errorMessageText.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(numberOfColumns, false));
        return top;
    }

    protected void okPressed() {
        try {
            this.errorMessageText.setText("");
            this.condaExecLocation = this.check("conda executable location", (StringButtonFieldEditor)this.fileFieldEditor);
            PyDevCondaPreferences.setExecutable((File)new File(this.condaExecLocation));
            this.additionalValidation();
            super.okPressed();
        }
        catch (ValidationFailedException validationFailedException) {
            // empty catch block
        }
    }

    protected void additionalValidation() throws ValidationFailedException {
    }

    private String check(String title, StringButtonFieldEditor fileFieldEditor) throws ValidationFailedException {
        String errorMessage;
        if (!fileFieldEditor.isValid() && (errorMessage = fileFieldEditor.getErrorMessage()) != null && !errorMessage.isEmpty()) {
            String msg = String.valueOf(title) + ": " + errorMessage;
            this.setErrorMessage(msg);
            throw new ValidationFailedException();
        }
        return fileFieldEditor.getStringValue();
    }

    protected void setErrorMessage(String msg) {
        this.errorMessageText.setText(msg);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = this.getOkButtonText();
        }
        Button button = super.createButton(parent, id, label, defaultButton);
        return button;
    }

    protected String getOkButtonText() {
        return "Save";
    }

    private GridData createGridData(int horizontalSpan) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = horizontalSpan;
        gridData.widthHint = 500;
        return gridData;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        CondaConfigDialog dialog = new CondaConfigDialog(shell);
        dialog.open();
    }
}

