/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf.package_manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.interpreter_managers.PyDevCondaPreferences;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.process_window.ProcessWindow;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_ui.utils.UIUtils;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.package_manager.AbstractPackageManager;

public class CondaPackageManager
extends AbstractPackageManager {
    private File prefix;

    public CondaPackageManager(IInterpreterInfo interpreterInfo, File prefix) {
        super(interpreterInfo);
        this.prefix = prefix;
    }

    public static List<File> listCondaEnvironments(File condaExecutable) {
        ArrayList<File> lst = new ArrayList<File>();
        String encoding = "utf-8";
        Tuple output = new SimpleRunner().runAndGetOutput(new String[]{condaExecutable.toString(), "env", "list", "--json"}, null, null, null, encoding);
        Log.logInfo((String)((String)output.o1));
        JsonObject jsonOutput = JsonValue.readFrom((String)((String)output.o1)).asObject();
        JsonArray envs = jsonOutput.get("envs").asArray();
        for (JsonValue env : envs.values()) {
            lst.add(new File(env.asString()));
        }
        return lst;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String[]> list() {
        block7: {
            listed = new ArrayList<String[]>();
            try {
                condaExecutable = PyDevCondaPreferences.findCondaExecutable((IInterpreterInfo)this.interpreterInfo);
            }
            catch (IInterpreterInfo.UnableToFindExecutableException e) {
                return this.errorToList(listed, e);
            }
            encoding = null;
            output = new SimpleRunner().runAndGetOutput(new String[]{condaExecutable.toString(), "list", "-p", this.prefix.toString(), "--json"}, null, null, null, encoding);
            try {
                readFrom = JsonValue.readFrom((String)((String)output.o1));
                asArray = readFrom.asArray();
                for (JsonValue value : asArray) {
                    asObject = value.asObject();
                    name = asObject.get("name");
                    version = asObject.get("version");
                    channel = asObject.get("channel");
                    buildString = asObject.get("build_string");
                    listed.add(new String[]{name.asString(), version.asString(), StringUtils.join((String)"", (Object[])new Object[]{buildString.asString(), " (", channel.asString(), ")"})});
                }
                break block7;
            }
            catch (Exception e) {
                output = new SimpleRunner().runAndGetOutput(new String[]{condaExecutable.toString(), "list", "-p", this.prefix.toString()}, null, null, null, encoding);
                splitInLines = StringUtils.splitInLines((String)((String)output.o1), (boolean)false);
                ** for (line : splitInLines)
            }
lbl-1000:
            // 1 sources

            {
                if ((line = line.trim()).startsWith("#")) continue;
                split = StringUtils.split((String)line, (char)' ');
                if (split.size() >= 3) {
                    listed.add(new String[]{(String)split.get(0), (String)split.get(1), StringUtils.join((String)" - ", split.subList(2, split.size() - 1))});
                    continue;
                }
                if (split.size() != 2) continue;
                listed.add(new String[]{(String)split.get(0), (String)split.get(1), ""});
                continue;
            }
        }
        return listed;
    }

    @Override
    protected String getPackageManagerName() {
        return "conda";
    }

    @Override
    public void manage() {
        this.manage(new String[0], false, null);
    }

    public void manage(final String[] initialCommands, boolean autoRun, File workingDir) {
        File condaExecutable;
        try {
            condaExecutable = PyDevCondaPreferences.findCondaExecutable((IInterpreterInfo)this.interpreterInfo);
        }
        catch (IInterpreterInfo.UnableToFindExecutableException e) {
            Log.log((Throwable)e);
            PyDialogHelpers.openException("Unable to find conda", e);
            return;
        }
        ProcessWindow processWindow = new ProcessWindow(UIUtils.getActiveShell()){

            @Override
            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("Manage conda");
            }

            @Override
            protected String[] getAvailableCommands() {
                ArrayList<String> lst = new ArrayList<String>(Arrays.asList(initialCommands));
                String prefixDir = new File(CondaPackageManager.this.interpreterInfo.getExecutableOrJar()).getParent();
                String prefixInfo = " -p " + prefixDir;
                int i = 0;
                while (i < lst.size()) {
                    String existing = (String)lst.get(i);
                    if (!existing.contains("-p")) {
                        if ((existing = existing.trim()).startsWith("install") || existing.startsWith("uninstall") || existing.startsWith("upgrade") || existing.startsWith("update") || existing.startsWith("clean") || existing.startsWith("list") || existing.startsWith("package") || existing.startsWith("remove") || existing.startsWith("search")) {
                            existing = String.valueOf(existing) + prefixInfo;
                        }
                        lst.set(i, existing);
                    }
                    ++i;
                }
                return (String[])ArrayUtils.concatArrays((Object[][])new String[][]{lst.toArray(new String[0]), {"install -p " + prefixDir + " <package>", "uninstall -p " + prefixDir + " <package>"}});
            }

            @Override
            protected String getSeeURL() {
                return "https://conda.io/docs/commands.html";
            }

            @Override
            public Tuple<Process, String> createProcess(String[] arguments) {
                this.clearOutput();
                AbstractShell.restartAllShells();
                String[] cmdLine = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{{condaExecutable.toString()}, arguments});
                return new SimpleRunner().run(cmdLine, this.workingDir, null, null);
            }
        };
        if (workingDir == null) {
            workingDir = condaExecutable.getParentFile();
        }
        processWindow.setParameters(null, null, condaExecutable, workingDir);
        processWindow.setAutoRun(autoRun);
        processWindow.open();
    }
}

