/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf.package_manager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Version;
import org.python.pydev.ast.codecompletion.shell.AbstractShell;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.process_window.ProcessWindow;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_ui.utils.UIUtils;
import org.python.pydev.ui.pythonpathconf.package_manager.AbstractPackageManager;

public class PipPackageManager
extends AbstractPackageManager {
    public PipPackageManager(IInterpreterInfo interpreterInfo) {
        super(interpreterInfo);
    }

    @Override
    public List<String[]> list() {
        Tuple output;
        ArrayList<String[]> listed = new ArrayList<String[]>();
        try {
            File pipExecutable = this.interpreterInfo.searchExecutableForInterpreter("pip", false);
            String encoding = null;
            output = new SimpleRunner().runAndGetOutput(new String[]{pipExecutable.toString(), "list", "--format=columns"}, null, null, null, encoding);
        }
        catch (IInterpreterInfo.UnableToFindExecutableException e) {
            SystemPythonNature nature = new SystemPythonNature(this.interpreterInfo.getModulesManager().getInterpreterManager(), this.interpreterInfo);
            String[] parameters = SimplePythonRunner.preparePythonCallParameters((String)this.interpreterInfo.getExecutableOrJar(), (String)"-m", (String[])new String[]{PipPackageManager.getPipModuleName(this.interpreterInfo), "list", "--format=columns"});
            output = new SimplePythonRunner().runAndGetOutput(parameters, null, (IPythonNature)nature, null, "utf-8");
        }
        List splitInLines = StringUtils.splitInLines((String)((String)output.o1), (boolean)false);
        for (String line : splitInLines) {
            List split = StringUtils.split((String)(line = line.trim()), (char)' ');
            if (split.size() != 2) continue;
            String p0 = ((String)split.get(0)).trim();
            String p1 = ((String)split.get(1)).trim();
            if (p0.toLowerCase().equals("package") && p1.toLowerCase().equals("version") || p0.toLowerCase().startsWith("--") && p1.toLowerCase().startsWith("--")) continue;
            listed.add(new String[]{p0.trim(), p1.trim(), "<pip>"});
        }
        if (((String)output.o2).toLowerCase().contains("no module named pip")) {
            listed.add(new String[]{"pip not installed (or not found) in interpreter", "", ""});
        } else {
            for (String s : StringUtils.iterLines((String)((String)output.o2))) {
                listed.add(new String[]{s, "", ""});
            }
        }
        return listed;
    }

    private static String getPipModuleName(IInterpreterInfo interpreterInfo) {
        String version = interpreterInfo.getVersion();
        Version version2 = new Version(version);
        if (version2.getMajor() <= 2 && version2.getMinor() <= 6) {
            return "pip.__main__";
        }
        return "pip";
    }

    @Override
    protected String getPackageManagerName() {
        return "pip";
    }

    @Override
    public void manage() {
        this.manage(new String[0], false);
    }

    public void manage(String[] initialCommand, boolean autoRun) {
        File pipExecutable;
        String[] availableCommands = new String[]{"install <package>", "uninstall <package>"};
        try {
            pipExecutable = this.interpreterInfo.searchExecutableForInterpreter("pip", false);
        }
        catch (IInterpreterInfo.UnableToFindExecutableException e) {
            availableCommands = new String[]{"-m " + PipPackageManager.getPipModuleName(this.interpreterInfo) + " install <package>", "-m " + PipPackageManager.getPipModuleName(this.interpreterInfo) + " uninstall <package>"};
            pipExecutable = new File(this.interpreterInfo.getExecutableOrJar());
        }
        final String[] availableCommandsFinal = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{initialCommand, availableCommands});
        final File pipExecutableFinal = pipExecutable;
        ProcessWindow processWindow = new ProcessWindow(UIUtils.getActiveShell()){

            @Override
            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("Manage pip");
            }

            @Override
            protected String[] getAvailableCommands() {
                return availableCommandsFinal;
            }

            @Override
            protected String getSeeURL() {
                return "https://pip.pypa.io/en/stable";
            }

            @Override
            public Tuple<Process, String> createProcess(String[] arguments) {
                this.clearOutput();
                AbstractShell.restartAllShells();
                String[] cmdLine = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{{pipExecutableFinal.toString()}, arguments});
                return new SimpleRunner().run(cmdLine, this.workingDir, this.pythonPathNature.getNature(), null);
            }
        };
        IPythonPathNature pythonPathNature = null;
        try {
            pythonPathNature = this.interpreterInfo.getModulesManager().getNature().getPythonPathNature();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        processWindow.setParameters(null, pythonPathNature, pipExecutableFinal, pipExecutableFinal.getParentFile());
        processWindow.setAutoRun(autoRun);
        processWindow.open();
    }
}

