/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.ast.refactoring.IPyRefactoringRequest;
import org.python.pydev.ast.refactoring.MultiModuleMoveRefactoringRequest;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.ui.refactoring.TextInputWizardPage;

public class PyRenameRefactoringWizard
extends RefactoringWizard {
    private static final String UPDATE_REFERENCES = "UPDATE_REFERENCES";
    private static final String SIMPLE_RESOURCE_RENAME = "SIMPLE_RESOURCE_RENAME";
    private final String fInputPageDescription;
    private IPyRefactoringRequest fRequest;
    private TextInputWizardPage inputPage;
    private String fInitialSetting;

    public PyRenameRefactoringWizard(Refactoring refactoring, String defaultPageTitle, String inputPageDescription, IPyRefactoringRequest request) {
        super(refactoring, 4);
        this.setDefaultPageTitle(defaultPageTitle);
        this.fInputPageDescription = inputPageDescription;
        this.fRequest = request;
        this.fInitialSetting = request.getInitialName();
        Assert.isNotNull((Object)this.fInitialSetting);
    }

    protected void addUserInputPages() {
        this.inputPage = this.createInputPage(this.fInputPageDescription, this.fInitialSetting);
        this.addPage((IWizardPage)this.inputPage);
    }

    protected TextInputWizardPage createInputPage(String message, final String initialSetting) {
        return new TextInputWizardPage(message, true, initialSetting){
            private Text textField;
            private IFile targetFile;

            @Override
            protected RefactoringStatus validateTextField(String text) {
                RefactoringStatus status = new RefactoringStatus();
                boolean acceptPoint = PyRenameRefactoringWizard.this.fRequest.isModuleRenameRefactoringRequest();
                if (PyStringUtils.isValidIdentifier((String)text, (boolean)acceptPoint)) {
                    PyRenameRefactoringWizard.this.fRequest.setInputName(text);
                } else {
                    status.addFatalError("The name: " + text + " is not a valid identifier.");
                }
                return status;
            }

            @Override
            protected Text createTextInputField(Composite parent, int style) {
                Text ret;
                this.textField = ret = super.createTextInputField(parent, style);
                this.setTextToFullName();
                return ret;
            }

            private void setTextToResourceName() {
                if (this.targetFile != null) {
                    String curr = this.targetFile.getName();
                    this.textField.setText(curr);
                    int i = curr.lastIndexOf(46);
                    if (i >= 0) {
                        this.textField.setSelection(0, i);
                    } else {
                        this.textField.selectAll();
                    }
                }
            }

            private void setTextToFullName() {
                this.textField.setText(initialSetting);
                String text = initialSetting;
                int i = text.lastIndexOf(46);
                if (i >= 0) {
                    this.textField.setSelection(i + 1, text.length());
                } else {
                    this.textField.selectAll();
                }
            }

            @Override
            protected void textModified(String text) {
                if (this.targetFile != null && PyRenameRefactoringWizard.this.fRequest.getSimpleResourceRename()) {
                    if (!this.isEmptyInputValid() && text.equals("")) {
                        this.setPageComplete(false);
                        this.setErrorMessage(null);
                        this.restoreMessage();
                        return;
                    }
                    if (!this.isInitialInputValid() && text.equals(this.targetFile.getName())) {
                        this.setPageComplete(false);
                        this.setErrorMessage(null);
                        this.restoreMessage();
                        return;
                    }
                    this.setPageComplete(this.validateTextField(text));
                }
                if (PyRenameRefactoringWizard.this.fRequest instanceof MultiModuleMoveRefactoringRequest) {
                    RefactoringStatus status;
                    if (text.length() == 0) {
                        status = new RefactoringStatus();
                        status.addInfo("Empty text: move to source folder");
                    } else {
                        status = this.validateTextField(text);
                    }
                    if (!status.hasFatalError()) {
                        PyRenameRefactoringWizard.this.fRequest.setInputName(text);
                    }
                    this.setPageComplete(status);
                } else {
                    super.textModified(text);
                }
            }

            public void createControl(Composite parent) {
                Composite superComposite = new Composite(parent, 0);
                this.setControl((Control)superComposite);
                this.initializeDialogUnits((Control)superComposite);
                superComposite.setLayout((Layout)new GridLayout());
                Composite composite = new Composite(superComposite, 0);
                composite.setLayoutData((Object)new GridData(768));
                GridLayout layout = new GridLayout();
                layout.numColumns = 4;
                layout.verticalSpacing = 8;
                composite.setLayout((Layout)layout);
                Label label = new Label(composite, 0);
                label.setText("New &value:");
                final Text text = this.createTextInputField(composite);
                GridData gd = new GridData(768);
                gd.widthHint = this.convertWidthInCharsToPixels(25);
                gd.horizontalSpan = 3;
                text.setLayoutData((Object)gd);
                if (PyRenameRefactoringWizard.this.fRequest.isModuleRenameRefactoringRequest()) {
                    Button updateReferencesButton = this.addOptionalUpdateReferencesCheckbox(composite);
                    IFile targetFile = PyRenameRefactoringWizard.this.fRequest.getIFileResource();
                    if (targetFile != null) {
                        this.targetFile = targetFile;
                        this.addResourceRenameCheckbox(composite, updateReferencesButton);
                    }
                }
                new Label(composite, 0);
                Button bt = new Button(composite, 8);
                bt.setText("as_&lower_underscore");
                bt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.setText(StringUtils.asStyleLowercaseUnderscores((String)text.getText()));
                    }
                });
                Button bt2 = new Button(composite, 8);
                bt2.setText("CamelCaseFirst&Upper");
                bt2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.setText(StringUtils.asStyleCamelCaseFirstUpper((String)text.getText()));
                    }
                });
                Button bt3 = new Button(composite, 8);
                bt3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        text.setText(StringUtils.asStyleCamelCaseFirstLower((String)text.getText()));
                    }
                });
                bt3.setText("&camelCaseFirstLower");
                Dialog.applyDialogFont((Control)superComposite);
            }

            protected Button addResourceRenameCheckbox(Composite result, final Button updateReferencesButton) {
                final Button resourceRename = new Button(result, 32);
                resourceRename.setText("&Simple Resource Rename / Change Extension?");
                IPreferenceStore preferences = PyDevUiPrefs.getPreferenceStore();
                preferences.setDefault(PyRenameRefactoringWizard.SIMPLE_RESOURCE_RENAME, false);
                boolean simpleResourceRenameBool = preferences.getBoolean(PyRenameRefactoringWizard.SIMPLE_RESOURCE_RENAME);
                resourceRename.setSelection(simpleResourceRenameBool);
                PyRenameRefactoringWizard.this.fRequest.setSimpleResourceRename(simpleResourceRenameBool);
                resourceRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IPreferenceStore preferences = PyDevUiPrefs.getPreferenceStore();
                        boolean simpleResourceRenameBool = resourceRename.getSelection();
                        updateReferencesButton.setVisible(!simpleResourceRenameBool);
                        preferences.setValue(PyRenameRefactoringWizard.SIMPLE_RESOURCE_RENAME, simpleResourceRenameBool);
                        (this).PyRenameRefactoringWizard.this.fRequest.setSimpleResourceRename(simpleResourceRenameBool);
                        if (simpleResourceRenameBool) {
                            this.setTextToResourceName();
                        } else {
                            this.setTextToFullName();
                        }
                    }
                });
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                resourceRename.setLayoutData((Object)gridData);
                updateReferencesButton.setVisible(!simpleResourceRenameBool);
                if (simpleResourceRenameBool) {
                    this.setTextToResourceName();
                }
                return resourceRename;
            }

            protected Button addOptionalUpdateReferencesCheckbox(Composite result) {
                final Button updateReferences = new Button(result, 32);
                updateReferences.setText("&Update References?");
                IPreferenceStore preferences = PyDevUiPrefs.getPreferenceStore();
                preferences.setDefault(PyRenameRefactoringWizard.UPDATE_REFERENCES, true);
                boolean updateRefs = preferences.getBoolean(PyRenameRefactoringWizard.UPDATE_REFERENCES);
                updateReferences.setSelection(updateRefs);
                PyRenameRefactoringWizard.this.fRequest.setUpdateReferences(updateRefs);
                updateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IPreferenceStore preferences = PyDevUiPrefs.getPreferenceStore();
                        boolean updateRefs = updateReferences.getSelection();
                        preferences.setValue(PyRenameRefactoringWizard.UPDATE_REFERENCES, updateRefs);
                        (this).PyRenameRefactoringWizard.this.fRequest.setUpdateReferences(updateRefs);
                    }
                });
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                updateReferences.setLayoutData((Object)gridData);
                return updateReferences;
            }
        };
    }
}

