/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.listing_utils.PyFileListing;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.LinkedListWarningOnSlowOperations;

public class PythonExistingSourceGroup {
    private Text singleSelectionText;
    private Button singleBrowseButton;
    private IPath linkTarget;
    protected String errorMessage;
    protected String warningMessage;
    protected List<IPath> projectLinkTargets = new LinkedListWarningOnSlowOperations();
    protected IProject iProject;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    protected void clearAllProblems() {
        this.errorMessage = null;
        this.warningMessage = null;
    }

    public PythonExistingSourceGroup(Composite parent, IProject project, ModifyListener sourceChangeListener) {
        this.createContents(parent, sourceChangeListener);
        this.setActiveProject(project);
    }

    protected PythonExistingSourceGroup() {
    }

    public void setActiveProject(IProject project) {
        if (this.iProject == project) {
            return;
        }
        this.iProject = project;
        this.projectLinkTargets.clear();
        if (project != null) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = project.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member.isLinked()) {
                        this.projectLinkTargets.add(member.getLocation());
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
            this.conflictCheck();
        }
    }

    protected void conflictCheck() {
        this.clearAllProblems();
        this.selectLinkTarget(Path.fromOSString((String)this.singleSelectionText.getText()));
    }

    private void createContents(final Composite parent, ModifyListener sourceChangeListener) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        group.setText("Location of existing source");
        this.singleSelectionText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.singleSelectionText.setLayoutData((Object)gd);
        this.singleSelectionText.setFont(font);
        this.singleSelectionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                PythonExistingSourceGroup.this.clearAllProblems();
                PythonExistingSourceGroup.this.selectLinkTarget(Path.fromOSString((String)PythonExistingSourceGroup.this.singleSelectionText.getText()));
            }
        });
        this.singleBrowseButton = new Button((Composite)group, 8);
        this.singleBrowseButton.setText("Browse...");
        this.singleBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                String selection = dialog.open();
                if (selection != null) {
                    PythonExistingSourceGroup.this.singleSelectionText.setText(selection);
                }
            }
        });
        this.singleSelectionText.addModifyListener(sourceChangeListener);
    }

    protected void selectLinkTarget(IPath linkPath) {
        this.linkTarget = this.validateLinkPath(linkPath) ? linkPath : null;
    }

    protected boolean validateLinkPath(IPath linkPath) {
        if (!linkPath.toFile().exists()) {
            String segment = linkPath.lastSegment();
            this.errorMessage = segment == null ? "External source location must not be null." : "External source location '" + segment + "' does not exist.";
            return false;
        }
        IPath rootPath = (this.iProject == null ? ResourcesPlugin.getWorkspace().getRoot() : this.iProject).getLocation();
        if (FileUtils.isPrefixOf((IPath)linkPath, (IPath)rootPath) || this.iProject != null && FileUtils.isPrefixOf((IPath)rootPath, (IPath)linkPath)) {
            this.errorMessage = "External source location '" + linkPath.lastSegment() + "' overlaps with the project directory.";
            return false;
        }
        for (IPath otherPath : this.projectLinkTargets) {
            if (!FileUtils.isPrefixOf((IPath)linkPath, (IPath)otherPath) && !FileUtils.isPrefixOf((IPath)otherPath, (IPath)linkPath)) continue;
            this.warningMessage = "Location '" + linkPath.lastSegment() + "' overlaps with the project resource '" + otherPath.lastSegment() + "'. This can cause unexpected side-effects.";
            break;
        }
        PyFileListing pyFileListing = PythonPathHelper.getModulesBelow((File)linkPath.toFile(), null, new ArrayList());
        if (pyFileListing == null || pyFileListing.getFoundPyFileInfos().size() == 0) {
            this.warningMessage = "Folder '" + linkPath.lastSegment() + "' does not contain any Python files.";
        }
        return true;
    }

    public IPath getLinkTarget() {
        return this.linkTarget;
    }
}

