/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.templates.PyDocumentTemplateContext;
import org.python.pydev.editor.templates.PyContextType;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.AbstractPythonWizardPage;
import org.python.pydev.ui.wizards.files.PythonPackageWizard;
import org.python.pydev.ui.wizards.files.TemplateSelectDialog;

public class PythonModuleWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonModuleWizard";

    public PythonModuleWizard() {
        super("Create a new Python module");
    }

    @Override
    protected AbstractPythonWizardPage createPathPage() {
        return new AbstractPythonWizardPage(this.description, this.selection){

            @Override
            protected boolean shouldCreatePackageSelect() {
                return true;
            }

            @Override
            protected String checkNameText(String text) {
                String result = super.checkNameText(text);
                if (result != null) {
                    return result;
                }
                IContainer p = this.getValidatedPackage();
                if (p != null && p.findMember(text.concat(".py")) != null) {
                    return "The module " + text + " already exists in " + p.getName() + ".";
                }
                return null;
            }
        };
    }

    @Override
    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        String validatedName;
        IFile file;
        IContainer validatedSourceFolder = this.filePage.getValidatedSourceFolder();
        if (validatedSourceFolder == null) {
            return null;
        }
        IContainer validatedPackage = this.filePage.getValidatedPackage();
        if (validatedPackage == null) {
            String packageText = this.filePage.getPackageText();
            if (packageText == null) {
                Log.log((String)"Package text not available");
                return null;
            }
            IFile packageInit = PythonPackageWizard.createPackage(monitor, validatedSourceFolder, packageText);
            if (packageInit == null) {
                Log.log((String)"Package not created");
                return null;
            }
            validatedPackage = packageInit.getParent();
        }
        if ((file = validatedPackage.getFile((IPath)new Path(validatedName = String.valueOf(this.filePage.getValidatedName()) + FileTypesPreferences.getDefaultDottedPythonExtension()))).exists()) {
            Log.log((String)"Module already exists.");
            return null;
        }
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
        return file;
    }

    @Override
    protected void afterEditorCreated(final IEditorPart openEditor) {
        if (!(openEditor instanceof PyEdit)) {
            return;
        }
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                PyEdit pyEdit = (PyEdit)openEditor;
                if (pyEdit.isDisposed()) {
                    return;
                }
                TemplateSelectDialog dialog = new TemplateSelectDialog(Display.getCurrent().getActiveShell());
                dialog.open();
                TemplatePersistenceData selectedTemplate = dialog.getSelectedTemplate();
                if (selectedTemplate == null) {
                    return;
                }
                Template template = selectedTemplate.getTemplate();
                Region region = new Region(0, 0);
                PyDocumentTemplateContext context = PyDocumentTemplateContext.createContext(new PyContextType(), (ITextViewer)pyEdit.getPySourceViewer(), (IRegion)region);
                TemplateProposal templateProposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
                templateProposal.apply((ITextViewer)pyEdit.getPySourceViewer(), '\n', 0, 0);
            }
        });
    }
}

