/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.AbstractPythonWizardPage;

public class PythonSourceFolderWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonSourceFolderWizard";

    public PythonSourceFolderWizard() {
        super("Create a new Source Folder");
    }

    @Override
    protected AbstractPythonWizardPage createPathPage() {
        return new AbstractPythonWizardPage(this.description, this.selection){

            @Override
            protected boolean shouldCreateSourceFolderSelect() {
                return false;
            }

            @Override
            protected boolean shouldCreatePackageSelect() {
                return false;
            }

            @Override
            protected String checkNameText(String text) {
                String result = super.checkNameText(text);
                if (result != null) {
                    return result;
                }
                if (this.getValidatedProject().findMember(text) != null) {
                    return "The source folder " + text + " already exists in project " + this.getValidatedProject().getName() + ".";
                }
                return null;
            }
        };
    }

    @Override
    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        IPythonNature nature;
        IProject project = this.filePage.getValidatedProject();
        String name = this.filePage.getValidatedName();
        if (project == null || !project.exists()) {
            throw new RuntimeException("The project selected does not exist in the workspace.");
        }
        IPythonPathNature pathNature = PythonNature.getPythonPathNature((IProject)project);
        if (pathNature == null && (pathNature = (nature = PythonNature.addNature((IProject)project, (IProgressMonitor)monitor, null, null, null, null, null)).getPythonPathNature()) == null) {
            throw new RuntimeException("Unable to add the nature to the seleted project.");
        }
        IFolder folder = project.getFolder(name);
        if (folder.exists()) {
            Log.log((String)"Source folder already exists. Nothing new was created");
            return null;
        }
        folder.create(true, true, monitor);
        String newPath = folder.getFullPath().toString();
        String curr = pathNature.getProjectSourcePath(false);
        if (curr == null) {
            curr = "";
        }
        if (curr.endsWith("|")) {
            curr = curr.substring(0, curr.length() - 1);
        }
        String newPathRel = PyStructureConfigHelpers.convertToProjectRelativePath((String)project.getFullPath().toString(), (String)newPath);
        if (curr.length() > 0) {
            Set projectSourcePathSet = pathNature.getProjectSourcePathSet(true);
            if (!projectSourcePathSet.contains(newPath)) {
                curr = String.valueOf(curr) + "|" + newPathRel;
            }
        } else {
            curr = newPathRel;
        }
        pathNature.setProjectSourcePath(curr);
        PythonNature.getPythonNature((IProject)project).rebuildPath();
        return null;
    }
}

