/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_ui.actions.BaseAction;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class FirstCharAction
extends BaseAction {
    protected SourceViewer viewer;

    @Override
    public void run(IAction action) {
        try {
            ITextEditor textEditor = this.getTextEditor();
            IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            this.perform(doc, selection);
        }
        catch (Exception e) {
            FirstCharAction.beep(e);
        }
    }

    private void perform(IDocument doc, ITextSelection selection) {
        boolean isAtFirstChar = this.isAtFirstVisibleChar(doc, selection.getOffset());
        if (!isAtFirstChar) {
            this.gotoFirstVisibleChar(doc, selection.getOffset());
        } else {
            this.gotoFirstChar(doc, selection.getOffset());
        }
    }

    protected void gotoFirstChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            this.setCaretPosition(offset);
        }
        catch (BadLocationException e) {
            FirstCharAction.beep((Exception)((Object)e));
        }
    }

    protected void gotoFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            this.setCaretPosition(TextSelectionUtils.getFirstCharPosition((IDocument)doc, (int)cursorOffset));
        }
        catch (BadLocationException e) {
            FirstCharAction.beep((Exception)((Object)e));
        }
    }

    protected boolean isAtFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            return TextSelectionUtils.getFirstCharPosition((IDocument)doc, (int)cursorOffset) == cursorOffset;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    @Override
    protected void setCaretPosition(int pos) throws BadLocationException {
        this.viewer.setSelectedRange(pos, 0);
    }

    public static VerifyKeyListener createVerifyKeyListener(final SourceViewer viewer) {
        return new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                ISelection selection;
                boolean isHome;
                if (event.doit && (isHome = KeyBindingHelper.matchesCommandKeybinding((KeyEvent)event, "org.eclipse.ui.edit.text.goto.lineStart")) && (selection = viewer.getSelection()) instanceof ITextSelection) {
                    FirstCharAction firstCharAction = new FirstCharAction();
                    firstCharAction.viewer = viewer;
                    firstCharAction.perform(viewer.getDocument(), (ITextSelection)selection);
                    event.doit = false;
                }
            }
        };
    }
}

