/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.actions;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.parsing.IScopesParser;
import org.python.pydev.shared_core.parsing.Scopes;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.ICharacterPairMatcher2;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.editor.BaseEditor;

public class ScopeSelectionAction {
    public static final String SELECTION_SCOPE_CACHE = "_SELECTION_SCOPE_CACHE_";

    public void perform(IDocument doc, ICoreTextSelection selection, BaseEditor editor) {
        ICoreTextSelection newSelection;
        IRegion peek;
        FastStack<IRegion> cache = ScopeSelectionAction.getCache(editor);
        Region initialRegion = new Region(selection.getOffset(), selection.getLength());
        if (cache.size() > 0 && !(peek = (IRegion)cache.peek()).equals(initialRegion)) {
            cache.clear();
        }
        if (cache.size() == 0) {
            cache.push((Object)initialRegion);
        }
        if (initialRegion.equals((Object)new Region((newSelection = this.getNewSelection(doc, selection, editor)).getOffset(), newSelection.getLength()))) {
            return;
        }
        editor.setSelection(newSelection.getOffset(), newSelection.getLength());
        cache.push((Object)new Region(newSelection.getOffset(), newSelection.getLength()));
    }

    public ICoreTextSelection getNewSelection(IDocument doc, ICoreTextSelection selection, BaseEditor editor) {
        return this.getNewSelection(doc, selection, editor.getPairMatcher(), editor.createScopesParser());
    }

    public ICoreTextSelection getNewSelection(IDocument doc, ICoreTextSelection selection, ICharacterPairMatcher2 pairMatcher, IScopesParser scopesParser) {
        try {
            Scopes scopes;
            IRegion scope;
            TextSelectionUtils ps = new TextSelectionUtils(doc, selection);
            String selectedText = ps.getSelectedText();
            if (selectedText.length() == 0) {
                int openingOffset;
                Tuple currToken = ps.getCurrToken();
                if (((String)currToken.o1).length() > 0) {
                    return new CoreTextSelection(((Integer)currToken.o2).intValue(), ((String)currToken.o1).length());
                }
                char c = '\u0000';
                try {
                    c = ps.getCharAtCurrentOffset();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (StringUtils.isClosingPeer((char)c) && (openingOffset = pairMatcher.searchForOpeningPeer(ps.getAbsoluteCursorOffset(), StringUtils.getPeer((char)c), c, doc)) >= 0) {
                    return new CoreTextSelection(openingOffset, ps.getAbsoluteCursorOffset() - openingOffset + 1);
                }
            } else {
                boolean tryMatchWithQualifier = true;
                boolean hasDotSelected = false;
                int i = 0;
                while (i < selectedText.length()) {
                    char c = selectedText.charAt(i);
                    if (c == '.') {
                        hasDotSelected = true;
                    } else if (!Character.isJavaIdentifierPart(c)) {
                        tryMatchWithQualifier = false;
                        break;
                    }
                    ++i;
                }
                if (tryMatchWithQualifier) {
                    Tuple currToken = ps.getCurrToken();
                    if (!hasDotSelected && !((String)currToken.o1).equals(selectedText)) {
                        return new CoreTextSelection(((Integer)currToken.o2).intValue(), ((String)currToken.o1).length());
                    }
                    Tuple currDottedToken = ps.getCurrDottedStatement(pairMatcher);
                    if (!((String)currDottedToken.o1).equals(selectedText)) {
                        return new CoreTextSelection(((Integer)currDottedToken.o2).intValue(), ((String)currDottedToken.o1).length());
                    }
                }
            }
            if ((scope = (scopes = scopesParser.createScopes(doc)).getScopeForSelection(selection.getOffset(), selection.getLength())) != null) {
                return new CoreTextSelection(scope.getOffset(), scope.getLength());
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        return selection;
    }

    private static String getCurrentSelectionCacheKey(BaseEditor pyEdit) {
        IDocument doc = pyEdit.getDocument();
        int length = doc.getLength();
        String key = Integer.toString(length);
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 document = (IDocumentExtension4)doc;
            long modificationStamp = document.getModificationStamp();
            key = String.valueOf(key) + " - " + modificationStamp;
        }
        return key;
    }

    public static FastStack<IRegion> getCache(BaseEditor pyEdit) {
        Map<String, Object> cache = pyEdit.getCache();
        String key = ScopeSelectionAction.getCurrentSelectionCacheKey(pyEdit);
        try {
            Tuple object = (Tuple)cache.get(SELECTION_SCOPE_CACHE);
            if (object != null && key.equals(object.o1)) {
                return (FastStack)object.o2;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        FastStack stack = new FastStack(20);
        cache.put(SELECTION_SCOPE_CACHE, new Tuple((Object)key, (Object)stack));
        return stack;
    }

    public void deselect(BaseEditor editor) {
        FastStack<IRegion> stack = ScopeSelectionAction.getCache(editor);
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        Region region = new Region(selection.getOffset(), selection.getLength());
        Iterator it = stack.topDownIterator();
        while (it.hasNext()) {
            IRegion iRegion = (IRegion)it.next();
            stack.pop();
            if (!iRegion.equals(region)) continue;
            if (stack.size() <= 0) break;
            IRegion peek = (IRegion)stack.peek();
            editor.setSelection(peek.getOffset(), peek.getLength());
            break;
        }
    }
}

