/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.actions;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class ShiftLeftAction {
    public static void perform(TextSelectionUtils ps, int tabWidth) throws BadLocationException {
        int endLineIndex = ps.getEndLineIndex();
        int startLineIndex = ps.getStartLineIndex();
        ps.selectCompleteLine();
        String selectedText = ps.getSelectedText();
        List ret = StringUtils.splitInLines((String)selectedText);
        int tabWidthToUse = tabWidth;
        for (String line : ret) {
            String lineIndent = TextSelectionUtils.getIndentationFromLine((String)line);
            if (lineIndent.length() <= 0 || lineIndent.startsWith("\t")) continue;
            int spaces = 0;
            int i = 0;
            while (i < lineIndent.length()) {
                char c = lineIndent.charAt(i);
                if (c != ' ') break;
                ++spaces;
                ++i;
            }
            if (spaces <= 0) continue;
            tabWidthToUse = Math.min(spaces, tabWidthToUse);
        }
        String defaultIndentStr = StringUtils.createSpaceString((int)tabWidthToUse);
        IDocument doc = ps.getDoc();
        int i = startLineIndex;
        while (i <= endLineIndex) {
            String line = ps.getLine(i);
            if (line.startsWith("\t")) {
                doc.replace(ps.getLineOffset(i), 1, "");
            } else if (line.startsWith(defaultIndentStr)) {
                doc.replace(ps.getLineOffset(i), defaultIndentStr.length(), "");
            }
            ++i;
        }
    }
}

