/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.bindings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.Tuple;

public class KeyBindingHelper {
    public static boolean matchesContentAssistKeybinding(KeyEvent event) {
        return KeyBindingHelper.matchesCommandKeybinding(event, "org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    public static KeySequence getContentAssistProposalBinding() {
        return KeyBindingHelper.getCommandKeyBinding("org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    public static boolean matchesQuickAssistKeybinding(KeyEvent event) {
        return KeyBindingHelper.matchesCommandKeybinding(event, "org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
    }

    public static KeySequence getQuickAssistProposalBinding() {
        return KeyBindingHelper.getCommandKeyBinding("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
    }

    public static boolean matchesKeysequence(Event event, KeySequence keySequence) {
        List<KeyStroke> possibleKeyStrokes = KeyBindingHelper.generatePossibleKeyStrokes(event);
        return KeyBindingHelper.matchesKeyStokesAndKeySequence(possibleKeyStrokes, keySequence);
    }

    public static boolean matchesCommandKeybinding(Event event, String commandId) {
        List<KeyStroke> possibleKeyStrokes = KeyBindingHelper.generatePossibleKeyStrokes(event);
        return KeyBindingHelper.matchesCommandKeybinding(possibleKeyStrokes, commandId);
    }

    private static boolean matchesCommandKeybinding(List<KeyStroke> possibleKeyStrokes, String commandId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] triggerSequenceArray = activeBindingsFor = bindingSvc.getActiveBindingsFor(commandId);
        int n = activeBindingsFor.length;
        int n2 = 0;
        while (n2 < n) {
            KeySequence keySequence;
            TriggerSequence seq = triggerSequenceArray[n2];
            if (seq instanceof KeySequence && KeyBindingHelper.matchesKeyStokesAndKeySequence(possibleKeyStrokes, keySequence = (KeySequence)seq)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean matchesCommandKeybinding(KeyEvent keyEvent, String commandId) {
        Event event = new Event();
        event.stateMask = keyEvent.stateMask;
        event.keyCode = keyEvent.keyCode;
        event.character = keyEvent.character;
        return KeyBindingHelper.matchesCommandKeybinding(event, commandId);
    }

    public static KeySequence getKeySequence(String text) throws ParseException, IllegalArgumentException {
        KeySequence keySequence = KeySequence.getInstance((KeyStroke)KeyStroke.getInstance((String)text));
        return keySequence;
    }

    private static List<KeyStroke> generatePossibleKeyStrokes(Event event) {
        int thirdAccelerator;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes;
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
        }
        return keyStrokes;
    }

    private static boolean matchesKeyStokesAndKeySequence(List<KeyStroke> possibleKeyStrokes, KeySequence keySequence) {
        KeyStroke[] keyStrokes;
        KeyStroke[] keyStrokeArray = keyStrokes = keySequence.getKeyStrokes();
        int n = keyStrokes.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke keyStroke = keyStrokeArray[n2];
            for (KeyStroke possibleKeyStroke : possibleKeyStrokes) {
                if (!keyStroke.equals((Object)possibleKeyStroke)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static KeySequence getCommandKeyBinding(String commandId) {
        Binding[] bindings;
        IBindingService bindingSvc;
        Assert.isNotNull((Object)commandId);
        try {
            bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
        TriggerSequence keyBinding = bindingSvc.getBestActiveBindingFor(commandId);
        if (keyBinding instanceof KeySequence) {
            return (KeySequence)keyBinding;
        }
        ArrayList<Tuple> matches = new ArrayList<Tuple>();
        Binding[] bindingArray = bindings = bindingSvc.getBindings();
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            ParameterizedCommand command = binding.getParameterizedCommand();
            if (command != null && commandId.equals(command.getId())) {
                matches.add(new Tuple((Object)binding, (Object)command));
            }
            ++n2;
        }
        for (Tuple tuple : matches) {
            if (!(((Binding)tuple.o1).getTriggerSequence() instanceof KeySequence)) continue;
            KeySequence keySequence = (KeySequence)((Binding)tuple.o1).getTriggerSequence();
            return keySequence;
        }
        return null;
    }

    public static void executeCommand(String commandId) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(commandId, null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

