/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.dialogs.ArrayContentProvider;
import org.python.pydev.shared_ui.tree.PyFilteredTree;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TreeViewer fTreeViewer;
    private static final int WIDGET_HEIGHT = 250;
    private static final int WIDGET_WIDTH = 300;
    private String natureId;
    private PatternFilter patternFilter;
    private PyFilteredTree filteredTree;
    private boolean multipleSelection;
    public IBaseLabelProvider labelProvider = new WorkbenchLabelProvider();

    public ProjectSelectionDialog(Shell parentShell, String natureId) {
        this(parentShell, natureId, false);
    }

    public ProjectSelectionDialog(Shell parentShell, String natureId, boolean multipleSelection) {
        super(parentShell);
        this.setTitle("Select project");
        this.setMessage("Select project");
        this.multipleSelection = multipleSelection;
        this.natureId = natureId;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this.patternFilter = new PatternFilter();
        this.filteredTree = PyFilteredTree.create(composite, this.patternFilter, true);
        this.fTreeViewer = this.filteredTree.getViewer();
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTreeViewer.getTree().setLayoutData((Object)data);
        this.fTreeViewer.setLabelProvider(this.labelProvider);
        this.fTreeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTreeViewer.getControl().setFont(font);
        if (this.natureId != null) {
            this.fTreeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IProject) {
                        IProject project = (IProject)element;
                        try {
                            return project.isOpen() && project.hasNature(ProjectSelectionDialog.this.natureId);
                        }
                        catch (CoreException e) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        IProject[] input = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.fTreeViewer.setInput((Object)input);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        SharedUiPlugin.setCssId(parent, "py-project-selection-dialog", true);
        return composite;
    }

    private void doSelectionChanged(Object[] objects) {
        if (this.multipleSelection) {
            if (objects.length == 0) {
                this.updateStatus((IStatus)new Status(4, "org.python.pydev.shared_ui", "Select one or more projects"));
                this.setSelectionResult(null);
            } else {
                this.updateStatus((IStatus)new Status(0, "org.python.pydev.shared_ui", String.valueOf(objects.length) + " selected"));
                this.setSelectionResult(objects);
            }
        } else if (objects.length != 1) {
            this.updateStatus((IStatus)new Status(4, "org.python.pydev.shared_ui", "Select one project"));
            this.setSelectionResult(null);
        } else {
            this.updateStatus((IStatus)new Status(0, "org.python.pydev.shared_ui", String.valueOf(objects.length) + " selected"));
            this.setSelectionResult(objects);
        }
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        Control area = this.getDialogArea();
        if (area != null) {
            SharedUiPlugin.fixSelectionStatusDialogStatusLineColor((Object)this, area.getBackground());
        }
    }

    protected void computeResult() {
        Object data;
        TreeItem[] items;
        Tree tree = this.fTreeViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        ArrayList<IProject> p = new ArrayList<IProject>();
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data2 = treeItem.getData();
            if (data2 instanceof IProject) {
                p.add((IProject)data2);
            }
            ++n2;
        }
        if (p.size() == 0 && (items = tree.getItems()).length > 0 && (data = items[0].getData()) instanceof IProject) {
            p.add((IProject)data);
        }
        this.setSelectionResult(p.toArray(new IProject[0]));
    }
}

