/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.editor_input;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.python.pydev.shared_ui.editor_input.PyEditorInputFactory;
import org.python.pydev.shared_ui.editor_input.PydevZipFileStorage;

public class PydevZipFileEditorInput
implements IStorageEditorInput,
IPathEditorInput,
IPersistableElement {
    private final PydevZipFileStorage storage;

    public PydevZipFileEditorInput(PydevZipFileStorage storage) {
        this.storage = storage;
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public File getFile() {
        return this.storage.zipFile;
    }

    public String getZipPath() {
        return this.storage.zipPath;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        return registry.getImageDescriptor(this.getContentType());
    }

    public String getName() {
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getContentType() {
        return this.storage.getFullPath().getFileExtension();
    }

    public String getToolTipText() {
        IPath fullPath = this.storage.getFullPath();
        if (fullPath == null) {
            return null;
        }
        return fullPath.toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    public IPath getPath() {
        return this.storage.getFullPath();
    }

    public void saveState(IMemento memento) {
        PyEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.python.pydev.editorinput.pyEditorInputFactory";
    }
}

