/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class FileFieldEditorCustom
extends FileFieldEditor {
    private int numColumnsTarget;
    private Composite parent;

    public FileFieldEditorCustom(String name, String labelText, Composite parent, int numColumnsTarget) {
        super(name, labelText, parent);
        this.numColumnsTarget = numColumnsTarget;
        this.parent = parent;
    }

    public FileFieldEditorCustom(String name, String labelText, Composite parent) {
        this(name, labelText, parent, -1);
    }

    public void fillIntoGrid(Composite parent, int numColumns) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof GridLayout));
        this.doFillIntoGrid(parent, numColumns);
        this.adjustForNumColumns(numColumns);
    }

    public int getNumberOfControls() {
        if (this.numColumnsTarget != -1) {
            return this.numColumnsTarget;
        }
        return super.getNumberOfControls();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void adjustForNumColumns(int numColumns) {
        if (this.numColumnsTarget != -1) {
            if (this.numColumnsTarget != 1) throw new AssertionError((Object)"Currently only handles numColumnsTarget == 1 or -1.");
            Label labelControl = this.getLabelControl();
            this.setLayoutHorizontalSpan((Control)labelControl, numColumns);
            this.setLayoutHorizontalSpan((Control)this.getTextControl(), numColumns);
            this.setLayoutHorizontalSpan((Control)this.getChangeControl(this.parent), numColumns);
            return;
        } else if (numColumns == 2) {
            Label labelControl = this.getLabelControl();
            GridData layoutData = (GridData)labelControl.getLayoutData();
            if (layoutData == null) {
                layoutData = new GridData();
                labelControl.setLayoutData((Object)layoutData);
            }
            layoutData.horizontalSpan = 2;
            ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = 1;
            return;
        } else if (numColumns == 1) {
            Label labelControl = this.getLabelControl();
            GridData layoutData = (GridData)labelControl.getLayoutData();
            if (layoutData == null) {
                layoutData = new GridData();
                labelControl.setLayoutData((Object)layoutData);
            }
            layoutData.horizontalSpan = 1;
            ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = 1;
            return;
        } else {
            ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = numColumns - 2;
        }
    }

    private void setLayoutHorizontalSpan(Control control, int numColumns) {
        GridData layoutData = (GridData)control.getLayoutData();
        if (layoutData == null) {
            layoutData = new GridData();
            control.setLayoutData((Object)layoutData);
        }
        layoutData.horizontalSpan = numColumns;
    }

    public void setVisible(boolean visible) {
        Label labelControl = this.getLabelControl();
        this.setVisible((Control)labelControl, visible);
        this.setVisible((Control)this.getTextControl(), visible);
        this.setVisible((Control)this.getChangeControl(this.parent), visible);
    }

    private void setVisible(Control control, boolean visible) {
        control.setVisible(visible);
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visible;
        }
    }
}

