/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.json.eclipsesource.ParseException;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.FontUtils;
import org.python.pydev.shared_ui.actions.FirstCharAction;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public final class JsonFieldEditor
extends FieldEditor {
    public static int UNLIMITED = -1;
    private boolean isValid = true;
    private boolean oldState = true;
    protected String oldValue;
    StyledText textField;
    private int heigthInChars = 80;
    private int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private ICallback<Optional<String>, JsonValue> additionalValidation = null;
    private final JsonFieldValidation fieldValidation = new JsonFieldValidation("JsonFieldValidation");
    private SourceViewer sourceViewer;
    private Document doc;
    private IContextActivation activateContext;

    protected JsonFieldEditor() {
    }

    public JsonFieldEditor(String name, String labelText, int widthInChars, int heigthInChars, Composite parent) {
        this.init(name, labelText);
        this.widthInChars = widthInChars;
        this.heigthInChars = heigthInChars;
        this.isValid = true;
        this.oldState = true;
        this.createControl(parent);
    }

    public JsonFieldEditor(String name, String labelText, int width, Composite parent) {
        this(name, labelText, width, 20, parent);
    }

    public JsonFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, UNLIMITED, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
    }

    public void setAdditionalJsonValidation(ICallback<Optional<String>, JsonValue> additionalValidation) {
        this.additionalValidation = additionalValidation;
    }

    /*
     * Unable to fully structure code
     */
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.textField = this.getTextControl(parent);
        gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.widthInChars != JsonFieldEditor.UNLIMITED || this.heigthInChars > 1) {
            gc = new GC((Drawable)this.textField);
            try {
                if (this.widthInChars != JsonFieldEditor.UNLIMITED) {
                    extent = gc.textExtent("X");
                    gd.widthHint = this.widthInChars * extent.x;
                } else {
                    gd.horizontalAlignment = 4;
                    gd.grabExcessHorizontalSpace = true;
                }
                if (this.heigthInChars <= 1) ** GOTO lbl23
                gd.heightHint = this.heigthInChars * gc.getFontMetrics().getHeight();
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
lbl23:
        // 3 sources

        this.textField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.textField.setText(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected StyledText getTextControl() {
        return this.textField;
    }

    public StyledText getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = this.createTextWidget(parent);
            this.textField.setFont(new Font((Device)parent.getDisplay(), FontUtils.getFontData(0, true)));
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    JsonFieldEditor.this.valueChanged();
                }
            });
            this.textField.addDisposeListener(event -> {
                StyledText styledText = this.textField = null;
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    protected StyledText createTextWidget(Composite parent) {
        int style = 2052;
        if (this.heigthInChars > 1) {
            style = 2626;
        }
        this.sourceViewer = new ProjectionViewer(parent, null, null, false, style);
        this.sourceViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
        this.doc = new Document();
        this.sourceViewer.setInput((Object)this.doc);
        StyledText styledText = this.sourceViewer.getTextWidget();
        final IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (contextService != null && JsonFieldEditor.this.activateContext == null) {
                    JsonFieldEditor.this.activateContext = contextService.activateContext("org.eclipse.ui.textEditorScope");
                }
            }

            public void focusLost(FocusEvent e) {
                if (contextService != null && JsonFieldEditor.this.activateContext != null) {
                    contextService.deactivateContext(JsonFieldEditor.this.activateContext);
                    JsonFieldEditor.this.activateContext = null;
                }
            }
        });
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (contextService != null && JsonFieldEditor.this.activateContext != null) {
                    contextService.deactivateContext(JsonFieldEditor.this.activateContext);
                    JsonFieldEditor.this.activateContext = null;
                }
            }
        });
        VerifyKeyListener createVerifyKeyListener = FirstCharAction.createVerifyKeyListener(this.sourceViewer);
        this.sourceViewer.appendVerifyKeyListener(createVerifyKeyListener);
        styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (KeyBindingHelper.matchesContentAssistKeybinding((KeyEvent)event) || KeyBindingHelper.matchesQuickAssistKeybinding((KeyEvent)event)) {
                    event.doit = false;
                    return;
                }
                if (KeyBindingHelper.matchesCommandKeybinding((KeyEvent)event, "org.eclipse.ui.edit.undo")) {
                    JsonFieldEditor.this.sourceViewer.getUndoManager().undo();
                    event.doit = false;
                    return;
                }
                if (KeyBindingHelper.matchesCommandKeybinding((KeyEvent)event, "org.eclipse.ui.edit.redo")) {
                    JsonFieldEditor.this.sourceViewer.getUndoManager().redo();
                    event.doit = false;
                    return;
                }
            }
        });
        return styledText;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValidToApply() {
        this.fieldValidation.doValidation(this.getText());
        try {
            this.fieldValidation.join();
        }
        catch (InterruptedException e) {
            Log.log((Throwable)e);
            return false;
        }
        return this.isValid;
    }

    private String getText() {
        return this.sourceViewer.getDocument().get();
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        this.isValid = false;
        this.fieldValidation.scheduleValidation(this.getText());
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEnabled(enabled);
    }

    private void handleStateChange(String content) {
        this.fireStateChanged("field_editor_is_valid", !this.isValid, this.isValid);
        String newValue = content;
        if (!content.equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    private void handleError(String content, Tuple<Integer, String> jsonError) {
        if (jsonError == null) {
            this.textField.setStyleRange(null);
            this.isValid = true;
            this.clearErrorMessage();
        } else {
            int line = (Integer)jsonError.o1;
            if (line != -1) {
                if (this.getText().equals(content)) {
                    PySelection sel = new PySelection((IDocument)new Document(content));
                    int errorLine = line - 1;
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = sel.getLineOffset(errorLine);
                    styleRange.length = sel.getLine(errorLine).length();
                    styleRange.fontStyle = 1;
                    styleRange.foreground = this.textField.getDisplay().getSystemColor(3);
                    this.textField.setStyleRange(null);
                    this.textField.setStyleRange(styleRange);
                }
            } else {
                this.textField.setStyleRange(null);
            }
            this.setErrorMessage((String)jsonError.o2);
            this.showErrorMessage();
        }
        this.handleStateChange(content);
        this.oldState = this.isValid;
    }

    private class JsonFieldValidation
    extends Job {
        private final long scheduleDelay = 500L;
        private String content;
        private Tuple<Integer, String> jsonError;

        public JsonFieldValidation(String name) {
            super(name);
            this.scheduleDelay = 500L;
        }

        public void doValidation(String content) {
            this.content = content;
            this.schedule();
        }

        public void scheduleValidation(String content) {
            this.content = content;
            this.schedule(500L);
        }

        private void refreshState() {
            Optional ret;
            this.jsonError = null;
            if (this.content == null) {
                this.jsonError = new Tuple((Object)-1, (Object)"JsonFieldEditor did not load properly.");
                return;
            }
            if (this.content.trim().isEmpty()) {
                return;
            }
            if (!this.checkTextFieldJSON()) {
                return;
            }
            if (JsonFieldEditor.this.additionalValidation != null && (ret = (Optional)JsonFieldEditor.this.additionalValidation.call((Object)JsonValue.readFrom((String)this.content))).isPresent()) {
                this.jsonError = new Tuple((Object)-1, (Object)((String)ret.get()));
            }
        }

        private boolean checkTextFieldJSON() {
            this.jsonError = this.getJSONError(this.content);
            return this.jsonError == null;
        }

        private Tuple<Integer, String> getJSONError(String str) {
            try {
                JsonValue.readFrom((String)str);
            }
            catch (ParseException e) {
                return new Tuple((Object)e.getLine(), (Object)e.getMessage());
            }
            return null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.refreshState();
            RunInUiThread.async(new Runnable(){

                @Override
                public void run() {
                    if (((JsonFieldValidation)JsonFieldValidation.this).JsonFieldEditor.this.textField == null || ((JsonFieldValidation)JsonFieldValidation.this).JsonFieldEditor.this.textField.isDisposed()) {
                        return;
                    }
                    JsonFieldEditor.this.handleError(JsonFieldValidation.this.content, JsonFieldValidation.this.jsonError);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

