/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.Reflection;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public abstract class ScopedFieldEditorPreferencePage
extends FieldEditorPreferencePage {
    private List<FieldEditor> fields;

    public ScopedFieldEditorPreferencePage(int style) {
        super(style);
    }

    public ScopedFieldEditorPreferencePage(String title, int style) {
        super(title, style);
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        if (this.fields == null) {
            this.fields = new ArrayList<FieldEditor>();
        }
        this.fields.add(editor);
    }

    public void saveToUserSettings(IScopedPreferences iScopedPreferences) {
        Map<String, Object> saveData = this.getFieldEditorsSaveData();
        if (saveData.size() > 0) {
            try {
                String message = iScopedPreferences.saveToUserSettings(saveData);
                DialogHelpers.openInfo("Results", message);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Error: unable to save requested settings to user settings", (String)e.getMessage(), (IStatus)SharedUiPlugin.makeErrorStatus(e, false));
            }
        } else {
            DialogHelpers.openCritical("Error: No preferences to save", "Error: No preferences to save (please report this as an error).");
        }
    }

    public void loadFromUserSettings(IScopedPreferences iScopedPreferences) {
        block6: {
            Map<String, Object> saveData = this.getFieldEditorsSaveData();
            if (saveData.size() > 0) {
                try {
                    Tuple loadedFromUserSettings = iScopedPreferences.loadFromUserSettings(saveData);
                    this.updateFieldEditorsData((Map)loadedFromUserSettings.o1);
                    if (((Map)loadedFromUserSettings.o1).size() == 0) {
                        DialogHelpers.openInfo("No saved preferences", "Unable to load any contents from the user settings.");
                        break block6;
                    }
                    if (((Set)loadedFromUserSettings.o2).size() > 0) {
                        DialogHelpers.openInfo("Partially loaded contents", "Partially loaded contents. Did not find the keys below in the user settings:\n  " + StringUtils.join((String)"\n  ", (Collection)((Collection)loadedFromUserSettings.o2)));
                        break block6;
                    }
                    DialogHelpers.openInfo("Loaded contents", "Showing contents loaded from user settings.");
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Error: unable to load requested settings from user settings", (String)e.getMessage(), (IStatus)SharedUiPlugin.makeErrorStatus(e, false));
                }
            } else {
                DialogHelpers.openCritical("Error: No preferences to load", "Error: No preferences to load (please report this as an error).");
            }
        }
    }

    public void loadFromProjectSettings(IScopedPreferences iScopedPreferences, IProject project) {
        block6: {
            Map<String, Object> saveData = this.getFieldEditorsSaveData();
            if (saveData.size() > 0) {
                try {
                    Tuple loadedFromUserSettings = iScopedPreferences.loadFromProjectSettings(saveData, project);
                    this.updateFieldEditorsData((Map)loadedFromUserSettings.o1);
                    if (((Map)loadedFromUserSettings.o1).size() == 0) {
                        DialogHelpers.openInfo("No saved preferences", "Unable to load any contents from the settings for the project: " + project.getName());
                        break block6;
                    }
                    if (((Set)loadedFromUserSettings.o2).size() > 0) {
                        DialogHelpers.openInfo("Partially loaded contents", "Partially loaded contents. Did not find the keys below in the settings for the project " + project.getName() + ":\n  " + StringUtils.join((String)"\n  ", (Collection)((Collection)loadedFromUserSettings.o2)));
                        break block6;
                    }
                    DialogHelpers.openInfo("Loaded contents", "Showing contents loaded from settings in project: " + project.getName());
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)("Error: unable to load requested settings from settings in project: " + project.getName()), (String)e.getMessage(), (IStatus)SharedUiPlugin.makeErrorStatus(e, false));
                }
            } else {
                DialogHelpers.openCritical("Error: No preferences to load", "Error: No preferences to load (please report this as an error).");
            }
        }
    }

    private void updateFieldEditorsData(Map<String, Object> loadData) throws IllegalArgumentException, IllegalAccessException {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                Object value;
                String preferenceName;
                if (pe instanceof BooleanFieldEditor) {
                    BooleanFieldEditor booleanFieldEditor = (BooleanFieldEditor)pe;
                    preferenceName = booleanFieldEditor.getPreferenceName();
                    value = (Boolean)loadData.get(preferenceName);
                    if (value == null) continue;
                    Field field = Reflection.getAttrFromClass(BooleanFieldEditor.class, (String)"checkBox");
                    field.setAccessible(true);
                    Button checkbox = (Button)field.get(booleanFieldEditor);
                    checkbox.setSelection(((Boolean)value).booleanValue());
                    continue;
                }
                if (pe instanceof IntegerFieldEditor) {
                    IntegerFieldEditor intFieldEditor = (IntegerFieldEditor)pe;
                    preferenceName = intFieldEditor.getPreferenceName();
                    Object loaded = loadData.get(preferenceName);
                    if (loaded == null) continue;
                    if (loaded instanceof Integer) {
                        Integer value2 = (Integer)loaded;
                        intFieldEditor.setStringValue(Integer.toString(value2));
                        continue;
                    }
                    intFieldEditor.setStringValue(loaded.toString());
                    continue;
                }
                if (pe instanceof StringFieldEditor) {
                    StringFieldEditor stringFieldEditor = (StringFieldEditor)pe;
                    preferenceName = stringFieldEditor.getPreferenceName();
                    value = (String)loadData.get(preferenceName);
                    if (value == null) continue;
                    stringFieldEditor.setStringValue((String)value);
                    continue;
                }
                if (pe instanceof ComboFieldEditor) {
                    ComboFieldEditor comboFieldEditor = (ComboFieldEditor)pe;
                    preferenceName = comboFieldEditor.getPreferenceName();
                    value = (String)loadData.get(preferenceName);
                    if (value == null) continue;
                    comboFieldEditor.updateComboForValue((String)value);
                    continue;
                }
                if (pe instanceof RadioGroupFieldEditor) {
                    RadioGroupFieldEditor radioGroupFieldEditor = (RadioGroupFieldEditor)pe;
                    preferenceName = radioGroupFieldEditor.getPreferenceName();
                    value = (String)loadData.get(preferenceName);
                    if (value == null) continue;
                    radioGroupFieldEditor.updateRadioForValue((String)value);
                    continue;
                }
                if (pe instanceof ScopedPreferencesFieldEditor || pe instanceof LinkFieldEditor || pe instanceof LabelFieldEditor) continue;
                Log.log((String)("Unhandled field editor:" + pe));
            }
        }
    }

    public Map<String, Object> getFieldEditorsSaveData() {
        HashMap<String, Object> saveData = new HashMap<String, Object>();
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                String preferenceName;
                if (pe instanceof BooleanFieldEditor) {
                    BooleanFieldEditor booleanFieldEditor = (BooleanFieldEditor)pe;
                    boolean booleanValue = booleanFieldEditor.getBooleanValue();
                    preferenceName = booleanFieldEditor.getPreferenceName();
                    saveData.put(preferenceName, booleanValue);
                    continue;
                }
                if (pe instanceof IntegerFieldEditor) {
                    IntegerFieldEditor intFieldEditor = (IntegerFieldEditor)pe;
                    String stringValue = intFieldEditor.getStringValue();
                    preferenceName = intFieldEditor.getPreferenceName();
                    try {
                        saveData.put(preferenceName, Integer.parseInt(stringValue));
                    }
                    catch (Exception e1) {
                        saveData.put(preferenceName, 0);
                    }
                    continue;
                }
                if (pe instanceof StringFieldEditor) {
                    StringFieldEditor stringFieldEditor = (StringFieldEditor)pe;
                    String stringValue = stringFieldEditor.getStringValue();
                    preferenceName = stringFieldEditor.getPreferenceName();
                    saveData.put(preferenceName, stringValue);
                    continue;
                }
                if (pe instanceof ComboFieldEditor) {
                    ComboFieldEditor comboFieldEditor = (ComboFieldEditor)pe;
                    String stringValue = comboFieldEditor.getComboValue();
                    preferenceName = comboFieldEditor.getPreferenceName();
                    saveData.put(preferenceName, stringValue);
                    continue;
                }
                if (pe instanceof RadioGroupFieldEditor) {
                    RadioGroupFieldEditor radioGroupFieldEditor = (RadioGroupFieldEditor)pe;
                    String stringValue = radioGroupFieldEditor.getRadioValue();
                    preferenceName = radioGroupFieldEditor.getPreferenceName();
                    saveData.put(preferenceName, stringValue);
                    continue;
                }
                if (pe instanceof ScopedPreferencesFieldEditor || pe instanceof LinkFieldEditor || pe instanceof LabelFieldEditor) continue;
                Log.log((String)("Unhandled field editor:" + pe));
            }
        }
        return saveData;
    }

    public void saveToProjectSettings(IScopedPreferences iScopedPreferences, IProject[] projects) {
        Map<String, Object> saveData = this.getFieldEditorsSaveData();
        if (saveData.size() > 0) {
            try {
                String message = iScopedPreferences.saveToProjectSettings(saveData, projects);
                DialogHelpers.openInfo("Contents saved", message);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Error: unable to save requested settings to user settings", (String)e.getMessage(), (IStatus)SharedUiPlugin.makeErrorStatus(e, false));
            }
        } else {
            DialogHelpers.openCritical("Error: No preferences to save", "Error: No preferences to save (please report this as an error).");
        }
    }

    public void saveToWorkspace() {
        super.performApply();
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        IPreferenceStore preferenceStore2 = this.getPreferenceStore();
        if (preferenceStore2 instanceof IPersistentPreferenceStore) {
            IPersistentPreferenceStore iPersistentPreferenceStore = (IPersistentPreferenceStore)preferenceStore2;
            try {
                iPersistentPreferenceStore.save();
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    public void loadFromWorkspace() {
        if (this.fields != null) {
            for (FieldEditor pe : this.fields) {
                pe.load();
            }
        }
    }
}

