/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.field_editors;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.preferences.ScopedPreferences;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.dialogs.ProjectSelectionDialog;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;

public class ScopedPreferencesFieldEditor
extends FieldEditor {
    private Composite toolBar;
    private IScopedPreferences iScopedPreferences;
    private WeakReference<ScopedFieldEditorPreferencePage> preferencesPage;
    private Label showingFrom;

    public ScopedPreferencesFieldEditor(Composite parent, String pluginName, ScopedFieldEditorPreferencePage preferencesPage) {
        this.init("__UNUSED__", "Some text");
        this.createControl(parent);
        this.iScopedPreferences = ScopedPreferences.get((String)pluginName);
        this.preferencesPage = new WeakReference<ScopedFieldEditorPreferencePage>(preferencesPage);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.toolBar.getLayoutData();
        gd.horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.toolBar = new Composite(parent, 0);
        this.toolBar.setLayout((Layout)new GridLayout(3, true));
        final Button bt = this.getButtonControl(this.toolBar, "Save to ...");
        bt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Control)bt);
                MenuItem item1 = new MenuItem(menu, 8);
                item1.setText("User settings");
                item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((ScopedFieldEditorPreferencePage)((Object)(this).ScopedPreferencesFieldEditor.this.preferencesPage.get())).saveToUserSettings((this).ScopedPreferencesFieldEditor.this.iScopedPreferences);
                    }
                });
                MenuItem item2 = new MenuItem(menu, 8);
                item2.setText("Project settings ...");
                item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProjectSelectionDialog dialog = new ProjectSelectionDialog(EditorUtils.getShell(), null, true);
                        dialog.labelProvider = ScopedPreferencesFieldEditor.this.createProjectsLabelProvider();
                        dialog.setMessage("Choose the projects to which the preferences should be applied.\n" + ScopedPreferencesFieldEditor.this.createDecorationLabel());
                        if (dialog.open() == 0) {
                            Object[] result = dialog.getResult();
                            IProject[] projects = new IProject[result.length];
                            int i = 0;
                            while (i < result.length) {
                                projects[i] = (IProject)result[i];
                                ++i;
                            }
                            ((ScopedFieldEditorPreferencePage)((Object)(this).ScopedPreferencesFieldEditor.this.preferencesPage.get())).saveToProjectSettings((this).ScopedPreferencesFieldEditor.this.iScopedPreferences, projects);
                        }
                    }
                });
                MenuItem item3 = new MenuItem(menu, 8);
                item3.setText("Workspace");
                item3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((ScopedFieldEditorPreferencePage)((Object)(this).ScopedPreferencesFieldEditor.this.preferencesPage.get())).saveToWorkspace();
                    }
                });
                Point loc = bt.getLocation();
                Rectangle rect = bt.getBounds();
                Point mLoc = new Point(loc.x, loc.y + rect.height);
                menu.setLocation(bt.getShell().getDisplay().map((Control)bt.getParent(), null, mLoc));
                menu.setVisible(true);
            }
        });
        final Button bt2 = this.getButtonControl(this.toolBar, "Show from ...");
        bt2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Control)bt2);
                MenuItem item1 = new MenuItem(menu, 8);
                item1.setText("User settings");
                item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((ScopedFieldEditorPreferencePage)((Object)(this).ScopedPreferencesFieldEditor.this.preferencesPage.get())).loadFromUserSettings((this).ScopedPreferencesFieldEditor.this.iScopedPreferences);
                        (this).ScopedPreferencesFieldEditor.this.showingFrom.setText("Showing from: User Settings");
                    }
                });
                MenuItem item2 = new MenuItem(menu, 8);
                item2.setText("Project settings ...");
                item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProjectSelectionDialog dialog = new ProjectSelectionDialog(EditorUtils.getShell(), null, false);
                        dialog.labelProvider = ScopedPreferencesFieldEditor.this.createProjectsLabelProvider();
                        dialog.setMessage("Choose the project from which the preferences should be shown.\n" + ScopedPreferencesFieldEditor.this.createDecorationLabel());
                        if (dialog.open() == 0) {
                            IProject project = (IProject)dialog.getFirstResult();
                            ((ScopedFieldEditorPreferencePage)((Object)(this).ScopedPreferencesFieldEditor.this.preferencesPage.get())).loadFromProjectSettings((this).ScopedPreferencesFieldEditor.this.iScopedPreferences, project);
                            (this).ScopedPreferencesFieldEditor.this.showingFrom.setText("Showing from: " + project.getName());
                        }
                    }
                });
                MenuItem item3 = new MenuItem(menu, 8);
                item3.setText("Workspace");
                item3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ((ScopedFieldEditorPreferencePage)((Object)(this).ScopedPreferencesFieldEditor.this.preferencesPage.get())).loadFromWorkspace();
                        (this).ScopedPreferencesFieldEditor.this.showingFrom.setText("Showing from: Workspace");
                    }
                });
                Point loc = bt2.getLocation();
                Rectangle rect = bt2.getBounds();
                Point mLoc = new Point(loc.x, loc.y + rect.height);
                menu.setLocation(bt2.getShell().getDisplay().map((Control)bt2.getParent(), null, mLoc));
                menu.setVisible(true);
            }
        });
        final Button bt3 = this.getButtonControl(this.toolBar, "Open location ...");
        bt3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Control)bt3);
                MenuItem item1 = new MenuItem(menu, 8);
                final File userSettingsLocation = ScopedPreferencesFieldEditor.this.iScopedPreferences.getUserSettingsLocation();
                item1.setText("User settings: " + userSettingsLocation);
                item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EditorUtils.openFile(userSettingsLocation);
                    }
                });
                MenuItem item2 = new MenuItem(menu, 8);
                item2.setText("Project settings ...");
                item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ProjectSelectionDialog dialog = new ProjectSelectionDialog(EditorUtils.getShell(), null, true);
                        dialog.labelProvider = ScopedPreferencesFieldEditor.this.createProjectsLabelProvider();
                        dialog.setMessage("Choose the projects from which the preference files should be opened.\n" + ScopedPreferencesFieldEditor.this.createDecorationLabel());
                        if (dialog.open() == 0) {
                            Object[] objectArray = dialog.getResult();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                IProject p = (IProject)o;
                                IFile projectSettingsLocation = (this).ScopedPreferencesFieldEditor.this.iScopedPreferences.getProjectSettingsLocation(p);
                                EditorUtils.openFile(projectSettingsLocation);
                                ++n2;
                            }
                        }
                    }
                });
                Point loc = bt3.getLocation();
                Rectangle rect = bt3.getBounds();
                Point mLoc = new Point(loc.x, loc.y + rect.height);
                menu.setLocation(bt3.getShell().getDisplay().map((Control)bt3.getParent(), null, mLoc));
                menu.setVisible(true);
            }
        });
        GridData gd = this.createFillGridData();
        gd.horizontalSpan = numColumns;
        this.toolBar.setLayoutData((Object)gd);
        this.showingFrom = new Label(parent, 0);
        this.showingFrom.setText("Showing from: Workspace");
    }

    private GridData createFillGridData() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    private String createDecorationLabel() {
        return "Legend:\n  *   project has all settings in this page\n  +   project has some settings in this page\n  ?  project has settings with errors";
    }

    private IBaseLabelProvider createProjectsLabelProvider() {
        return new WorkbenchLabelProvider(){
            private Map<Object, String> elementToDecorationCache = new HashMap<Object, String>();

            protected String decorateText(String input, Object element) {
                String ret = super.decorateText(input, element);
                String decoration = this.getDecoration(element);
                ret = String.valueOf(ret) + " " + decoration;
                return ret;
            }

            private String getDecoration(Object element) {
                String decoration;
                String ret = this.elementToDecorationCache.get(element);
                if (ret != null) {
                    return ret;
                }
                ScopedFieldEditorPreferencePage preferencePage = (ScopedFieldEditorPreferencePage)((Object)ScopedPreferencesFieldEditor.this.preferencesPage.get());
                Map<String, Object> saveData = preferencePage.getFieldEditorsSaveData();
                try {
                    Tuple loadFromProjectSettings = ScopedPreferencesFieldEditor.this.iScopedPreferences.loadFromProjectSettings(saveData, (IProject)element);
                    decoration = ((Map)loadFromProjectSettings.o1).size() == 0 ? "" : (((Set)loadFromProjectSettings.o2).size() == 0 ? "*" : "+");
                }
                catch (Exception e) {
                    decoration = "?";
                }
                this.elementToDecorationCache.put(element, ret);
                return decoration;
            }
        };
    }

    private Button getButtonControl(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData gd = this.createFillGridData();
        button.setLayoutData((Object)gd);
        return button;
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.toolBar.setEnabled(enabled);
    }
}

