/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.python.pydev.shared_ui.tree.PyFilteredTree;

public abstract class ContentOutlinePageWithFilter
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private ListenerList selectionChangedListeners = new ListenerList();
    protected TreeViewer treeViewer;
    protected PatternFilter patternFilter;
    protected FilteredTree filter;

    public void createControl(Composite parent) {
        this.patternFilter = new PatternFilter();
        this.filter = PyFilteredTree.create(parent, this.patternFilter, false);
        this.treeViewer = this.filter.getViewer();
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public Control getControl() {
        if (this.filter == null) {
            return null;
        }
        return this.filter;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        this.filter.getFilterControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }
}

