/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;

public class OutlineSortByNameAction
extends Action {
    private final String PREF_ALPHA_SORT;
    ViewerSorter sortByNameSorter;
    private WeakReference<BaseOutlinePage> page;

    public OutlineSortByNameAction(BaseOutlinePage page, IImageCache imageCache, String pluginId) {
        super("Sort by name", 2);
        this.PREF_ALPHA_SORT = String.valueOf(pluginId) + ".OUTLINE_ALPHA_SORT";
        this.page = new WeakReference<BaseOutlinePage>(page);
        this.setChecked(page.getStore().getBoolean(this.PREF_ALPHA_SORT));
        this.setAlphaSort(this.isChecked());
        this.setImageDescriptor(ImageCache.asImageDescriptor(imageCache.getDescriptor("icons/alphab_sort_co.gif")));
        this.setToolTipText("Sort by name");
    }

    public void setAlphaSort(boolean doSort) {
        BaseOutlinePage p = (BaseOutlinePage)((Object)this.page.get());
        if (p != null) {
            p.getStore().setValue(this.PREF_ALPHA_SORT, doSort);
            if (this.sortByNameSorter == null) {
                this.sortByNameSorter = new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        return ((Comparable)e1).compareTo(e2);
                    }
                };
            }
            p.getTreeViewer().setSorter(doSort ? this.sortByNameSorter : null);
        }
    }

    public void run() {
        this.setAlphaSort(this.isChecked());
    }
}

