/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.proposals;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class PyCompletionPresentationUpdater {
    private StyleRange fRememberedStyleRange;
    private ITextPresentationListener fTextPresentationListener;

    private static Color getForegroundColor() {
        return Display.getDefault().getSystemColor(3);
    }

    private static Color getBackgroundColor() {
        return Display.getDefault().getSystemColor(7);
    }

    private StyleRange createStyleRange(ITextViewer viewer, int initialOffset, int len) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return null;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= initialOffset + len) {
            return null;
        }
        int length = initialOffset + len - modelCaret;
        Color foreground = PyCompletionPresentationUpdater.getForegroundColor();
        Color background = PyCompletionPresentationUpdater.getBackgroundColor();
        return new StyleRange(modelCaret, length, foreground, background);
    }

    public void selected(final ITextViewer viewer, final int initialOffset, final int len) {
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
        StyleRange range = this.createStyleRange(viewer, initialOffset, len);
        if (range == null) {
            return;
        }
        this.fRememberedStyleRange = range;
        if (this.fTextPresentationListener == null) {
            this.fTextPresentationListener = new ITextPresentationListener(){

                public void applyTextPresentation(TextPresentation textPresentation) {
                    PyCompletionPresentationUpdater.this.fRememberedStyleRange = PyCompletionPresentationUpdater.this.createStyleRange(viewer, initialOffset, len);
                    if (PyCompletionPresentationUpdater.this.fRememberedStyleRange != null) {
                        textPresentation.mergeStyleRange(PyCompletionPresentationUpdater.this.fRememberedStyleRange);
                    }
                }
            };
            ((ITextViewerExtension4)viewer).addTextPresentationListener(this.fTextPresentationListener);
        }
        this.repairPresentation(viewer);
    }

    public void unselected(ITextViewer viewer) {
        if (this.fTextPresentationListener != null) {
            ((ITextViewerExtension4)viewer).removeTextPresentationListener(this.fTextPresentationListener);
            this.fTextPresentationListener = null;
        }
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
    }

    private void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length);
            } else {
                viewer.invalidateTextPresentation();
            }
        }
    }
}

