/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.search.ui.ISearchQuery;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.search.ICustomSearchQuery;
import org.python.pydev.shared_ui.search.ScopeAndData;
import org.python.pydev.shared_ui.search.SearchIndexData;
import org.python.pydev.shared_ui.search.StringMatcherWithIndexSemantics;

public abstract class AbstractSearchIndexQuery
implements ISearchQuery,
ICustomSearchQuery {
    public final String text;
    protected ScopeAndData scopeAndData;
    private boolean caseSensitive = true;
    private boolean wholeWord = true;

    public AbstractSearchIndexQuery(String text) {
        this.text = text;
        this.scopeAndData = new ScopeAndData(2, "");
    }

    public AbstractSearchIndexQuery(SearchIndexData data) {
        this.text = data.textPattern;
        this.caseSensitive = data.isCaseSensitive;
        this.wholeWord = data.isWholeWord;
        this.scopeAndData = new ScopeAndData(data.scope, data.scopeData);
    }

    public boolean getIgnoreCase() {
        return !this.caseSensitive;
    }

    @Override
    public String getSearchString() {
        return this.text;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean isWholeWord() {
        return this.wholeWord;
    }

    @Override
    public boolean isRegexSearch() {
        return false;
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.text;
        if (nMatches == 1) {
            return StringUtils.format((String)"%s - 1 match", (Object[])new Object[]{searchString});
        }
        return StringUtils.format((String)"%s - %s matches", (Object[])new Object[]{searchString, nMatches});
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public StringMatcherWithIndexSemantics createStringMatcher() {
        boolean ignoreCase = this.getIgnoreCase();
        StringMatcherWithIndexSemantics stringMatcher = new StringMatcherWithIndexSemantics(this.text, ignoreCase, this.wholeWord);
        return stringMatcher;
    }

    protected Set<String> makeTextFieldPatternsToSearchFromText() {
        HashSet<String> split = new HashSet<String>();
        for (String s : StringUtils.splitForIndexMatching((String)this.text)) {
            String lowerCase = s.toLowerCase();
            if (!this.isWholeWord()) {
                if (!lowerCase.startsWith("*")) {
                    lowerCase = String.valueOf('*') + lowerCase;
                }
                if (!lowerCase.endsWith("*")) {
                    lowerCase = String.valueOf(lowerCase) + '*';
                }
            }
            split.add(lowerCase);
        }
        return split;
    }
}

