/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class PyMarkerUIUtils {
    public static Position getMarkerPosition(IDocument document, IMarker marker, IAnnotationModel model) {
        int line;
        int end;
        Position ret;
        if (model instanceof AbstractMarkerAnnotationModel && (ret = ((AbstractMarkerAnnotationModel)model).getMarkerPosition(marker)) != null) {
            return ret;
        }
        int start = MarkerUtilities.getCharStart((IMarker)marker);
        if (start > (end = MarkerUtilities.getCharEnd((IMarker)marker))) {
            end = start + end;
            start = end - start;
            end -= start;
        }
        if (start == -1 && end == -1 && (line = MarkerUtilities.getLineNumber((IMarker)marker)) > 0 && document != null) {
            try {
                end = start = document.getLineOffset(line - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (start > -1 && end > -1) {
            return new Position(start, end - start);
        }
        return null;
    }

    public static IResource getResourceForTextEditor(ITextEditor textEditor) {
        IEditorInput input = textEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }
}

