/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.word_boundaries;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.python.pydev.shared_ui.word_boundaries.CustomWordIterator;
import org.python.pydev.shared_ui.word_boundaries.DocumentCharacterIterator;

public class SubWordActions {
    private ISubWordEditorWrapper wrapper;

    public SubWordActions(ISubWordEditorWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public int widgetOffset2ModelOffset(ISourceViewer viewer, int caretOffset) {
        return this.wrapper.widgetOffset2ModelOffset(viewer, caretOffset);
    }

    public boolean validateEditorInputState() {
        return this.wrapper.validateEditorInputState();
    }

    public boolean isBlockSelectionModeEnabled() {
        return this.wrapper.isBlockSelectionModeEnabled();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.wrapper.getPreferenceStore();
    }

    public boolean isEditorInputModifiable() {
        return this.wrapper.isEditorInputModifiable();
    }

    public int modelOffset2WidgetOffset(ISourceViewer viewer, int position) {
        return this.wrapper.modelOffset2WidgetOffset(viewer, position);
    }

    protected ISourceViewer getSourceViewer() {
        return this.wrapper.getSourceViewer();
    }

    public class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!SubWordActions.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (SubWordActions.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = SubWordActions.this.modelOffset2WidgetOffset(viewer, position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(127);
            } else {
                int length;
                int caret;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    caret = selection.x;
                    length = selection.y;
                } else {
                    caret = SubWordActions.this.widgetOffset2ModelOffset(viewer, text.getCaretOffset());
                    length = position - caret;
                }
                try {
                    viewer.getDocument().replace(caret, length, "");
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void update() {
            this.setEnabled(SubWordActions.this.isEditorInputModifiable());
        }
    }

    public class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!SubWordActions.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (SubWordActions.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = SubWordActions.this.modelOffset2WidgetOffset(viewer, position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(8);
            } else {
                int length;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    position = selection.x;
                    length = selection.y;
                } else {
                    length = SubWordActions.this.widgetOffset2ModelOffset(viewer, text.getCaretOffset()) - position;
                }
                try {
                    viewer.getDocument().replace(position, length, "");
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void update() {
            this.setEnabled(SubWordActions.this.isEditorInputModifiable());
        }
    }

    public static interface ISubWordEditorWrapper {
        public int widgetOffset2ModelOffset(ISourceViewer var1, int var2);

        public boolean validateEditorInputState();

        public boolean isBlockSelectionModeEnabled();

        public IPreferenceStore getPreferenceStore();

        public boolean isEditorInputModifiable();

        public int modelOffset2WidgetOffset(ISourceViewer var1, int var2);

        public ISourceViewer getSourceViewer();
    }

    public class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(SubWordActions.this.modelOffset2WidgetOffset(SubWordActions.this.getSourceViewer(), position));
        }
    }

    public class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(SubWordActions.this.modelOffset2WidgetOffset(SubWordActions.this.getSourceViewer(), position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected CustomWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(SubWordActions.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CustomWordIterator();
        }

        public void run() {
            IPreferenceStore store = SubWordActions.this.getPreferenceStore();
            if (store.getString("WORD_NAVIGATION_STYLE").equals("NATIVE")) {
                super.run();
                return;
            }
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = SubWordActions.this.widgetOffset2ModelOffset(viewer, viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int next = this.findNextPosition(position);
                if (SubWordActions.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            int widget = -1;
            int next = position;
            while (next != -1 && widget == -1) {
                if ((next = this.fIterator.following(next)) == -1) continue;
                widget = SubWordActions.this.modelOffset2WidgetOffset(viewer, next);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && next != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                    if (position != linkedPositionEnd && linkedPositionEnd < next) {
                        next = linkedPositionEnd;
                    }
                } else {
                    int nextLinkedPositionOffset;
                    LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                    if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                        next = nextLinkedPositionOffset;
                    }
                }
            }
            return next;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected CustomWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(SubWordActions.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new CustomWordIterator();
        }

        public void run() {
            IPreferenceStore store = SubWordActions.this.getPreferenceStore();
            if (store.getString("WORD_NAVIGATION_STYLE").equals("NATIVE")) {
                super.run();
                return;
            }
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = SubWordActions.this.widgetOffset2ModelOffset(viewer, viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int previous = this.findPreviousPosition(position);
                if (SubWordActions.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            int widget = -1;
            int previous = position;
            while (previous != -1 && widget == -1) {
                if ((previous = this.fIterator.preceding(previous)) == -1) continue;
                widget = SubWordActions.this.modelOffset2WidgetOffset(viewer, previous);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && previous != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionOffset = linkedPosition.getOffset();
                    if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                        previous = linkedPositionOffset;
                    }
                } else {
                    int previousLinkedPositionEnd;
                    LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                    if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                        previous = previousLinkedPositionEnd;
                    }
                }
            }
            return previous;
        }

        protected abstract void setCaretPosition(int var1);
    }

    public class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = SubWordActions.this.modelOffset2WidgetOffset(viewer, position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    public class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = SubWordActions.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = SubWordActions.this.modelOffset2WidgetOffset(viewer, position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }
}

